% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransformationSummary.R
\name{transformationSummary}
\alias{transformationSummary}
\title{Summarize the transformations in a CoDa model (internal)}
\usage{
transformationSummary(lm_res)
}
\arguments{
\item{lm_res}{class "lm"}
}
\value{
data.frame, with list columns
}
\description{
Extract from a CoDa model estimated by \code{lm()} all information related to the
log-ratio transformations of the variables and the parameters.
}
\details{
The structure of the return value resembles a data.frame where most columns
are lists instead of vectors.
The rows in this data.frame correspond to the variables used for fitting
the model.
The columns store information on the log-ratio transformations and their
associated bases (K and F).
Additionally the clr parameters and the covariance matrices are retained.
}
\author{
Lukas Dargel
}
\keyword{internal}
