% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaGenData.R
\name{ctmaGenData}
\alias{ctmaGenData}
\title{ctmaGenData}
\usage{
ctmaGenData(
  activeDirectory = NULL,
  burnin = 0,
  cint = NULL,
  coresToUse = 2,
  diff = NULL,
  digits = 4,
  doPar = 1,
  drift = NULL,
  empirical = TRUE,
  sampleSizes = 100,
  lambda = NULL,
  latentNames = NULL,
  manifestMeans = 0,
  manifestVars = 0,
  missings = 0,
  n.latent = NULL,
  n.manifest = 0,
  randomIntercepts = 0,
  T0means = 0,
  T0var = NULL,
  TIpreds = NULL,
  tpoints = 10,
  tpointTargets = NULL
)
}
\arguments{
\item{activeDirectory}{defines active directory where files are saved. No default.}

\item{burnin}{vector of inititial time points to be deleted (default = 0)}

\item{cint}{list of cint matrices. By default (NULL), cint matrices will be used that create a steady-state (i.e., means at all time points = T0means)}

\item{coresToUse}{if neg., the value is subtracted from available cores, else value = cores to use.}

\item{diff}{list of diffusion matrices. By default (NULL), diffusion matrices will be used that create a steady-state (i.e., covariance at all time points = T0var)}

\item{digits}{number of digits used for rounding (in outputs).}

\item{doPar}{parallel generating of data. A value > 1 will generate data for doPar studies (default = 1) in parallel mode during which no output is generated (screen remains silent).}

\item{drift}{list of drift matrices. No default (all = NULL).}

\item{empirical}{whether (default) or not generated data should allow for exact estimation of parameters (no random variance; not useful for MC simulations). This applies only if all Tpoints are used (see argument missings)}

\item{sampleSizes}{vector of sample sizes. Default = 100.}

\item{lambda}{list of matrices. By default all are diagonal matrices with 1 in the diagonal.}

\item{latentNames}{names for latent variables (default = NULL using generic names)}

\item{manifestMeans}{list of manifest mean matrices. By default all are = 0.}

\item{manifestVars}{list of manifest error (co-)variances matrices. By default all are = 0.}

\item{missings}{proportion of missings (default = 0, which does not delete any value)}

\item{n.latent}{number of latent variables of the model No default (all = NULL).}

\item{n.manifest}{number of manifest variables of the model (if left empty it will assumed to be identical with n.latent).}

\item{randomIntercepts}{list of (co-)variances matrices of TIpreds (traits). By default all are = 0.}

\item{T0means}{list of Time 0 mean levels. By default all are = 0.}

\item{T0var}{list of Time 0 (co-)variance matrices. No default (all = NULL).}

\item{TIpreds}{list of time-independent predictors, e.g., the moderators that were used to create the drift matrices. No default (all = NULL).}

\item{tpoints}{vector of number of tpoints to be generated (default = 10).}

\item{tpointTargets}{list of vectors of tpoints to be selectd (default = burnin:tpoints).}
}
\value{
ctmaGenData returns a list containing ...
}
\description{
Generates data from lists of parameters (drift, diffusion etc). Experimental!!
}
\examples{
# Fit a ctsem model to all three primary studies summarized in
# CoTiMAstudyList_3 and save the three fitted models
\dontrun{
CoTiMAInitFit_3 <- ctmaInit(primaryStudies=CoTiMAstudyList_3,
                            n.latent=2,
                            checkSingleStudyResults=FALSE,
                            activeDirectory="/Users/tmp/") # adapt!
summary(CoTiMAInitFit_3)
}

}
