% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaOTL.R
\name{ctmaOTL}
\alias{ctmaOTL}
\title{ctmaOTL}
\usage{
ctmaOTL(
  ctmaFitFit = NULL,
  timeRange = NULL,
  driftMat = NULL,
  undoTimeScaling = NULL,
  digits = 4
)
}
\arguments{
\item{ctmaFitFit}{fit object created with ctmaFit}

\item{timeRange}{time range across which to search for the optimal lag}

\item{driftMat}{drift matrix. Either a ctmaFit object or a drift matrix has to be supplied}

\item{undoTimeScaling}{undos time scaling in case the the scaleTime argument was used with ctmaFit}

\item{digits}{digits used for rounding}
}
\value{
A corrected correlation matrix (corEmpcov). Corrections leading to r > 1.0 are set to 1.0.
}
\description{
Numerically determines the optimal time lag (largest effect magnitude)
}
\examples{
\dontrun{
OTL <- ctmaOTL(ctmaFitFit=CoTiMA::CoTiMAFullFit_6_new)
print(OTL)
}

}
