% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDescendants.R
\name{getDescendants}
\alias{getDescendants}
\title{Get descendant codes for a given concept}
\usage{
getDescendants(cdm, conceptId, withAncestor = FALSE)
}
\arguments{
\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{conceptId}{concept_id to search}

\item{withAncestor}{If TRUE, return column with ancestor. In case of multiple
ancestors, concepts will be separated by ";".}
}
\value{
The descendants of a given concept id.
}
\description{
Get descendant codes for a given concept
}
\examples{
\donttest{
library(CodelistGenerator)
cdm <- mockVocabRef()
getDescendants(cdm = cdm, conceptId = 1)
}
}
