% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimDemographics.R
\name{trimDemographics}
\alias{trimDemographics}
\title{Trim cohort on patient demographics}
\usage{
trimDemographics(
  cohort,
  cohortId = NULL,
  ageRange = NULL,
  sex = NULL,
  minPriorObservation = NULL,
  minFutureObservation = NULL,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{ageRange}{A list of vectors specifying minimum and maximum age.}

\item{sex}{Can be "Both", "Male" or "Female".}

\item{minPriorObservation}{A minimum number of continuous prior observation
days in the database.}

\item{minFutureObservation}{A minimum number of continuous future observation
days in the database.}

\item{name}{Name of the new cohort table created in the cdm object.}
}
\value{
The cohort table with only records for individuals satisfying the
demographic requirements
}
\description{
\code{trimDemographics()} resets the cohort start and end date based on the
specified demographic criteria is satisfied.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()

cdm$cohort1 |>
  trimDemographics(ageRange = list(c(10, 30)))
}
}
