# Stations in ROI works as expected

    Code
      stations_test
    Output
      Simple feature collection with 1 feature and 20 fields
      Geometry type: POINT
      Dimension:     XY
      Bounding box:  xmin: -74.71311 ymin: 4.161028 xmax: -74.71311 ymax: 4.161028
      CRS:           NA
             codigo                       nombre     categoria   tecnologia estado
      1744 21190290 CARMEN DE APICALA [21190290] Pluviométrica Convencional Activa
           departamento         municipio    latitud     longitud altitud
      1744       Tolima Carmen De Apicalá 4.16102778 -74.71311111     321
           fecha_instalacion             area_operativa corriente area_hidrografica
      1744        1972-02-15 Area Operativa 10 - Tolima  San Juan   Magdalena Cauca
           zona_hidrografica subzona_hidrografica
      1744    Alto Magdalena          Río Sumapaz
                                                               entidad
      1744 INSTITUTO DE HIDROLOGIA METEOROLOGIA Y ESTUDIOS AMBIENTALES
           fecha_suspension codigo_municipio codigo_departamento
      1744             <NA>            73148                  73
                             geometry
      1744 POINT (-74.71311 4.161028)

# Climate Stations works as expected

    Code
      download_climate_stations(stations = stations_test, start_date = "2010-10-01",
        end_date = "2010-12-10", tag = "PTPM_CON")
    Message
      ColOpenData provides open data derived from Departamento Administrativo
      Nacional de Estadística (DANE), and Instituto de Hidrología,
      Meteorología y Estudios Ambientales (IDEAM) but with modifications for
      specific functional needs. These changes may alter the structure,
      format, or content, meaning the data does not reflect the official
      dataset. The package is developed independently, with no endorsement or
      involvement from these institutions or any Colombian government body.
      The authors of ColOpenData are not liable for how users utilize the
      data, and users are responsible for any outcomes from their use or
      analysis of the data.
      Stored by Universidad de Los Andes under the Epiverse TRACE initiative.
    Output
          station    longitude   latitude       date     hour      tag value
      1  21190290 -74.71311111 4.16102778 2010-10-01 07:00:00 PTPM_CON    34
      2  21190290 -74.71311111 4.16102778 2010-10-02 07:00:00 PTPM_CON    16
      3  21190290 -74.71311111 4.16102778 2010-10-03 07:00:00 PTPM_CON    33
      4  21190290 -74.71311111 4.16102778 2010-10-04 07:00:00 PTPM_CON     2
      5  21190290 -74.71311111 4.16102778 2010-10-05 07:00:00 PTPM_CON    45
      6  21190290 -74.71311111 4.16102778 2010-10-06 07:00:00 PTPM_CON    25
      7  21190290 -74.71311111 4.16102778 2010-10-07 07:00:00 PTPM_CON    30
      8  21190290 -74.71311111 4.16102778 2010-10-08 07:00:00 PTPM_CON     0
      9  21190290 -74.71311111 4.16102778 2010-10-09 07:00:00 PTPM_CON     0
      10 21190290 -74.71311111 4.16102778 2010-10-10 07:00:00 PTPM_CON     0
      11 21190290 -74.71311111 4.16102778 2010-10-11 07:00:00 PTPM_CON     0
      12 21190290 -74.71311111 4.16102778 2010-10-12 07:00:00 PTPM_CON     0
      13 21190290 -74.71311111 4.16102778 2010-10-13 07:00:00 PTPM_CON     3
      14 21190290 -74.71311111 4.16102778 2010-10-14 07:00:00 PTPM_CON     4
      15 21190290 -74.71311111 4.16102778 2010-10-15 07:00:00 PTPM_CON     1
      16 21190290 -74.71311111 4.16102778 2010-10-16 07:00:00 PTPM_CON     2
      17 21190290 -74.71311111 4.16102778 2010-10-17 07:00:00 PTPM_CON     1
      18 21190290 -74.71311111 4.16102778 2010-10-18 07:00:00 PTPM_CON    13
      19 21190290 -74.71311111 4.16102778 2010-10-19 07:00:00 PTPM_CON     2
      20 21190290 -74.71311111 4.16102778 2010-10-20 07:00:00 PTPM_CON     0
      21 21190290 -74.71311111 4.16102778 2010-10-21 07:00:00 PTPM_CON     0
      22 21190290 -74.71311111 4.16102778 2010-10-22 07:00:00 PTPM_CON     0
      23 21190290 -74.71311111 4.16102778 2010-10-23 07:00:00 PTPM_CON     0
      24 21190290 -74.71311111 4.16102778 2010-10-24 07:00:00 PTPM_CON     0
      25 21190290 -74.71311111 4.16102778 2010-10-25 07:00:00 PTPM_CON     4
      26 21190290 -74.71311111 4.16102778 2010-10-26 07:00:00 PTPM_CON     2
      27 21190290 -74.71311111 4.16102778 2010-10-27 07:00:00 PTPM_CON     1
      28 21190290 -74.71311111 4.16102778 2010-10-28 07:00:00 PTPM_CON     4
      29 21190290 -74.71311111 4.16102778 2010-10-29 07:00:00 PTPM_CON     0
      30 21190290 -74.71311111 4.16102778 2010-10-30 07:00:00 PTPM_CON     0
      31 21190290 -74.71311111 4.16102778 2010-10-31 07:00:00 PTPM_CON     0
      32 21190290 -74.71311111 4.16102778 2010-11-01 07:00:00 PTPM_CON     0
      33 21190290 -74.71311111 4.16102778 2010-11-02 07:00:00 PTPM_CON     0
      34 21190290 -74.71311111 4.16102778 2010-11-03 07:00:00 PTPM_CON     0
      35 21190290 -74.71311111 4.16102778 2010-11-04 07:00:00 PTPM_CON     3
      36 21190290 -74.71311111 4.16102778 2010-11-05 07:00:00 PTPM_CON    20
      37 21190290 -74.71311111 4.16102778 2010-11-06 07:00:00 PTPM_CON    30
      38 21190290 -74.71311111 4.16102778 2010-11-07 07:00:00 PTPM_CON     0
      39 21190290 -74.71311111 4.16102778 2010-11-08 07:00:00 PTPM_CON    18
      40 21190290 -74.71311111 4.16102778 2010-11-09 07:00:00 PTPM_CON    27
      41 21190290 -74.71311111 4.16102778 2010-11-10 07:00:00 PTPM_CON     0
      42 21190290 -74.71311111 4.16102778 2010-11-11 07:00:00 PTPM_CON     1
      43 21190290 -74.71311111 4.16102778 2010-11-12 07:00:00 PTPM_CON    13
      44 21190290 -74.71311111 4.16102778 2010-11-13 07:00:00 PTPM_CON    28
      45 21190290 -74.71311111 4.16102778 2010-11-14 07:00:00 PTPM_CON     3
      46 21190290 -74.71311111 4.16102778 2010-11-15 07:00:00 PTPM_CON    10
      47 21190290 -74.71311111 4.16102778 2010-11-16 07:00:00 PTPM_CON     0
      48 21190290 -74.71311111 4.16102778 2010-11-17 07:00:00 PTPM_CON     0
      49 21190290 -74.71311111 4.16102778 2010-11-18 07:00:00 PTPM_CON     8
      50 21190290 -74.71311111 4.16102778 2010-11-19 07:00:00 PTPM_CON     0
      51 21190290 -74.71311111 4.16102778 2010-11-20 07:00:00 PTPM_CON     0
      52 21190290 -74.71311111 4.16102778 2010-11-21 07:00:00 PTPM_CON     0
      53 21190290 -74.71311111 4.16102778 2010-11-22 07:00:00 PTPM_CON     0
      54 21190290 -74.71311111 4.16102778 2010-11-23 07:00:00 PTPM_CON     0
      55 21190290 -74.71311111 4.16102778 2010-11-24 07:00:00 PTPM_CON     2
      56 21190290 -74.71311111 4.16102778 2010-11-25 07:00:00 PTPM_CON     1
      57 21190290 -74.71311111 4.16102778 2010-11-26 07:00:00 PTPM_CON     0
      58 21190290 -74.71311111 4.16102778 2010-11-27 07:00:00 PTPM_CON     0
      59 21190290 -74.71311111 4.16102778 2010-11-28 07:00:00 PTPM_CON     0
      60 21190290 -74.71311111 4.16102778 2010-11-29 07:00:00 PTPM_CON     0
      61 21190290 -74.71311111 4.16102778 2010-11-30 07:00:00 PTPM_CON     5
      62 21190290 -74.71311111 4.16102778 2010-12-01 07:00:00 PTPM_CON    14
      63 21190290 -74.71311111 4.16102778 2010-12-02 07:00:00 PTPM_CON     1
      64 21190290 -74.71311111 4.16102778 2010-12-03 07:00:00 PTPM_CON     5
      65 21190290 -74.71311111 4.16102778 2010-12-04 07:00:00 PTPM_CON     0
      66 21190290 -74.71311111 4.16102778 2010-12-05 07:00:00 PTPM_CON     2
      67 21190290 -74.71311111 4.16102778 2010-12-06 07:00:00 PTPM_CON     0
      68 21190290 -74.71311111 4.16102778 2010-12-07 07:00:00 PTPM_CON     0
      69 21190290 -74.71311111 4.16102778 2010-12-08 07:00:00 PTPM_CON     0
      70 21190290 -74.71311111 4.16102778 2010-12-09 07:00:00 PTPM_CON     0

# Climate data from geometry works as expected

    Code
      download_climate_geom(geometry = apicala, start_date = "2010-10-01", end_date = "2010-11-10",
        tag = "PTPM_CON")
    Message
      ColOpenData provides open data derived from Departamento Administrativo
      Nacional de Estadística (DANE), and Instituto de Hidrología,
      Meteorología y Estudios Ambientales (IDEAM) but with modifications for
      specific functional needs. These changes may alter the structure,
      format, or content, meaning the data does not reflect the official
      dataset. The package is developed independently, with no endorsement or
      involvement from these institutions or any Colombian government body.
      The authors of ColOpenData are not liable for how users utilize the
      data, and users are responsible for any outcomes from their use or
      analysis of the data.
      Stored by Universidad de Los Andes under the Epiverse TRACE initiative.
    Output
          station    longitude   latitude       date     hour      tag value
      1  21190290 -74.71311111 4.16102778 2010-10-01 07:00:00 PTPM_CON    34
      2  21190290 -74.71311111 4.16102778 2010-10-02 07:00:00 PTPM_CON    16
      3  21190290 -74.71311111 4.16102778 2010-10-03 07:00:00 PTPM_CON    33
      4  21190290 -74.71311111 4.16102778 2010-10-04 07:00:00 PTPM_CON     2
      5  21190290 -74.71311111 4.16102778 2010-10-05 07:00:00 PTPM_CON    45
      6  21190290 -74.71311111 4.16102778 2010-10-06 07:00:00 PTPM_CON    25
      7  21190290 -74.71311111 4.16102778 2010-10-07 07:00:00 PTPM_CON    30
      8  21190290 -74.71311111 4.16102778 2010-10-08 07:00:00 PTPM_CON     0
      9  21190290 -74.71311111 4.16102778 2010-10-09 07:00:00 PTPM_CON     0
      10 21190290 -74.71311111 4.16102778 2010-10-10 07:00:00 PTPM_CON     0
      11 21190290 -74.71311111 4.16102778 2010-10-11 07:00:00 PTPM_CON     0
      12 21190290 -74.71311111 4.16102778 2010-10-12 07:00:00 PTPM_CON     0
      13 21190290 -74.71311111 4.16102778 2010-10-13 07:00:00 PTPM_CON     3
      14 21190290 -74.71311111 4.16102778 2010-10-14 07:00:00 PTPM_CON     4
      15 21190290 -74.71311111 4.16102778 2010-10-15 07:00:00 PTPM_CON     1
      16 21190290 -74.71311111 4.16102778 2010-10-16 07:00:00 PTPM_CON     2
      17 21190290 -74.71311111 4.16102778 2010-10-17 07:00:00 PTPM_CON     1
      18 21190290 -74.71311111 4.16102778 2010-10-18 07:00:00 PTPM_CON    13
      19 21190290 -74.71311111 4.16102778 2010-10-19 07:00:00 PTPM_CON     2
      20 21190290 -74.71311111 4.16102778 2010-10-20 07:00:00 PTPM_CON     0
      21 21190290 -74.71311111 4.16102778 2010-10-21 07:00:00 PTPM_CON     0
      22 21190290 -74.71311111 4.16102778 2010-10-22 07:00:00 PTPM_CON     0
      23 21190290 -74.71311111 4.16102778 2010-10-23 07:00:00 PTPM_CON     0
      24 21190290 -74.71311111 4.16102778 2010-10-24 07:00:00 PTPM_CON     0
      25 21190290 -74.71311111 4.16102778 2010-10-25 07:00:00 PTPM_CON     4
      26 21190290 -74.71311111 4.16102778 2010-10-26 07:00:00 PTPM_CON     2
      27 21190290 -74.71311111 4.16102778 2010-10-27 07:00:00 PTPM_CON     1
      28 21190290 -74.71311111 4.16102778 2010-10-28 07:00:00 PTPM_CON     4
      29 21190290 -74.71311111 4.16102778 2010-10-29 07:00:00 PTPM_CON     0
      30 21190290 -74.71311111 4.16102778 2010-10-30 07:00:00 PTPM_CON     0
      31 21190290 -74.71311111 4.16102778 2010-10-31 07:00:00 PTPM_CON     0
      32 21190290 -74.71311111 4.16102778 2010-11-01 07:00:00 PTPM_CON     0
      33 21190290 -74.71311111 4.16102778 2010-11-02 07:00:00 PTPM_CON     0
      34 21190290 -74.71311111 4.16102778 2010-11-03 07:00:00 PTPM_CON     0
      35 21190290 -74.71311111 4.16102778 2010-11-04 07:00:00 PTPM_CON     3
      36 21190290 -74.71311111 4.16102778 2010-11-05 07:00:00 PTPM_CON    20
      37 21190290 -74.71311111 4.16102778 2010-11-06 07:00:00 PTPM_CON    30
      38 21190290 -74.71311111 4.16102778 2010-11-07 07:00:00 PTPM_CON     0
      39 21190290 -74.71311111 4.16102778 2010-11-08 07:00:00 PTPM_CON    18
      40 21190290 -74.71311111 4.16102778 2010-11-09 07:00:00 PTPM_CON    27

# Climate data from code works as expected

    Code
      download_climate(code = "73148", start_date = "2018-10-01", end_date = "2018-11-10",
        tag = "PTPM_CON")
    Message
      ColOpenData provides open data derived from Departamento Administrativo
      Nacional de Estadística (DANE), and Instituto de Hidrología,
      Meteorología y Estudios Ambientales (IDEAM) but with modifications for
      specific functional needs. These changes may alter the structure,
      format, or content, meaning the data does not reflect the official
      dataset. The package is developed independently, with no endorsement or
      involvement from these institutions or any Colombian government body.
      The authors of ColOpenData are not liable for how users utilize the
      data, and users are responsible for any outcomes from their use or
      analysis of the data.
      Stored by Universidad de Los Andes under the Epiverse TRACE initiative.
    Output
          station    longitude   latitude       date     hour      tag value
      1  21190290 -74.71311111 4.16102778 2018-10-01 07:00:00 PTPM_CON    44
      2  21190290 -74.71311111 4.16102778 2018-10-02 07:00:00 PTPM_CON     0
      3  21190290 -74.71311111 4.16102778 2018-10-03 07:00:00 PTPM_CON    35
      4  21190290 -74.71311111 4.16102778 2018-10-04 07:00:00 PTPM_CON     4
      5  21190290 -74.71311111 4.16102778 2018-10-05 07:00:00 PTPM_CON    59
      6  21190290 -74.71311111 4.16102778 2018-10-06 07:00:00 PTPM_CON     5
      7  21190290 -74.71311111 4.16102778 2018-10-07 07:00:00 PTPM_CON    37
      8  21190290 -74.71311111 4.16102778 2018-10-08 07:00:00 PTPM_CON    61
      9  21190290 -74.71311111 4.16102778 2018-10-09 07:00:00 PTPM_CON    10
      10 21190290 -74.71311111 4.16102778 2018-10-10 07:00:00 PTPM_CON    61
      11 21190290 -74.71311111 4.16102778 2018-10-11 07:00:00 PTPM_CON     2
      12 21190290 -74.71311111 4.16102778 2018-10-12 07:00:00 PTPM_CON     0
      13 21190290 -74.71311111 4.16102778 2018-10-13 07:00:00 PTPM_CON     0
      14 21190290 -74.71311111 4.16102778 2018-10-14 07:00:00 PTPM_CON     0
      15 21190290 -74.71311111 4.16102778 2018-10-15 07:00:00 PTPM_CON     0
      16 21190290 -74.71311111 4.16102778 2018-10-16 07:00:00 PTPM_CON     0
      17 21190290 -74.71311111 4.16102778 2018-10-17 07:00:00 PTPM_CON     0
      18 21190290 -74.71311111 4.16102778 2018-10-18 07:00:00 PTPM_CON    10
      19 21190290 -74.71311111 4.16102778 2018-10-19 07:00:00 PTPM_CON     0
      20 21190290 -74.71311111 4.16102778 2018-10-20 07:00:00 PTPM_CON     0
      21 21190290 -74.71311111 4.16102778 2018-10-21 07:00:00 PTPM_CON     0
      22 21190290 -74.71311111 4.16102778 2018-10-22 07:00:00 PTPM_CON     0
      23 21190290 -74.71311111 4.16102778 2018-10-23 07:00:00 PTPM_CON     0
      24 21190290 -74.71311111 4.16102778 2018-10-24 07:00:00 PTPM_CON     0
      25 21190290 -74.71311111 4.16102778 2018-10-25 07:00:00 PTPM_CON    18
      26 21190290 -74.71311111 4.16102778 2018-10-26 07:00:00 PTPM_CON    26
      27 21190290 -74.71311111 4.16102778 2018-10-27 07:00:00 PTPM_CON    74
      28 21190290 -74.71311111 4.16102778 2018-10-28 07:00:00 PTPM_CON    17
      29 21190290 -74.71311111 4.16102778 2018-10-29 07:00:00 PTPM_CON     5
      30 21190290 -74.71311111 4.16102778 2018-10-30 07:00:00 PTPM_CON     0
      31 21190290 -74.71311111 4.16102778 2018-10-31 07:00:00 PTPM_CON     0
      32 21190290 -74.71311111 4.16102778 2018-11-01 07:00:00 PTPM_CON     0
      33 21190290 -74.71311111 4.16102778 2018-11-02 07:00:00 PTPM_CON     0
      34 21190290 -74.71311111 4.16102778 2018-11-03 07:00:00 PTPM_CON     0
      35 21190290 -74.71311111 4.16102778 2018-11-04 07:00:00 PTPM_CON     0
      36 21190290 -74.71311111 4.16102778 2018-11-05 07:00:00 PTPM_CON     0
      37 21190290 -74.71311111 4.16102778 2018-11-06 07:00:00 PTPM_CON     0
      38 21190290 -74.71311111 4.16102778 2018-11-07 07:00:00 PTPM_CON     3
      39 21190290 -74.71311111 4.16102778 2018-11-08 07:00:00 PTPM_CON    78
      40 21190290 -74.71311111 4.16102778 2018-11-09 07:00:00 PTPM_CON     0

