% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{admitted_students_df}
\alias{admitted_students_df}
\title{Admitted Students to the Science Faculty, UNAL (2013-I)}
\format{
A data frame with 445 observations and 15 variables:
\describe{
  \item{carr}{Career or program admitted to (factor with 7 levels)}
  \item{mate}{Mathematics exam score (numeric)}
  \item{cien}{Science exam score (numeric)}
  \item{soci}{Social sciences exam score (numeric)}
  \item{text}{Textual reasoning exam score (numeric)}
  \item{imag}{Abstract/imagery reasoning exam score (numeric)}
  \item{exam}{Total exam score (numeric)}
  \item{gene}{Gender of the student (factor with 2 levels)}
  \item{estr}{Socio-economic stratum (factor with 3 levels)}
  \item{orig}{Origin or background classification (factor with 3 levels)}
  \item{edad}{Age group (factor with 4 levels)}
  \item{niLE}{Mother tongue indicator (factor with 2 levels)}
  \item{niMa}{Maternal education indicator (factor with 2 levels)}
  \item{stra}{Admission stratum or classification (factor with 7 levels)}
  \item{age}{Age of the student in years (numeric)}
}
}
\source{
Data taken from the \pkg{FactoClass} package version 1.2.9
}
\usage{
data(admitted_students_df)
}
\description{
This dataset, admitted_students_df, is a data frame containing the admission
scores and socio-demographic information of 445 students admitted to the seven
careers of the Facultad de Ciencias at the Universidad Nacional de Colombia,
Bogotá, for the first semester of 2013. It includes exam component scores, gender,
socio-economic background, and other demographic attributes.
}
\details{
The dataset name has been kept as 'admitted_students_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the ColombiAPI package and assists users in identifying
its specific characteristics. The suffix 'df' indicates that the dataset is
a data frame object. The original content has not been modified in any way.
}
