% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfp_gasdata.R
\name{cfp_gasdata}
\alias{cfp_gasdata}
\alias{cfp_gasdata.data.frame}
\alias{cfp_gasdata.cfp_dat}
\title{Soil gas concentration data}
\usage{
cfp_gasdata(x, ...)

\method{cfp_gasdata}{data.frame}(x, id_cols, ...)

\method{cfp_gasdata}{cfp_dat}(x, ...)
}
\arguments{
\item{x}{A \code{data.frame} with the following columns:
\describe{
\item{gas}{The gas of that observation.}
\item{depth (cm)}{The depth of the observation.}
\item{x_ppm (ppm)}{The concentration in ppm.}
\item{any of \code{id_cols}}{All id_cols that identify one profile uniquely.}
}}

\item{...}{not used}

\item{id_cols}{Column names in data.frame that uniquely identify each
profile.}
}
\value{
A \code{cfp_gasdata} object.
}
\description{
Create a \link{cfp_gasdata} object. This is a data.frame containing gas
concentration data for one or multiple soil profiles.
Each soil profile is uniquely identified by columns in the data.frame
specified by the \code{id_cols} attribute.
}
\examples{
cfp_gasdata(
  ConFluxPro::gasdata,
  id_cols = c("site", "Date"))
### Also used to extract the gasdata object from cfp_dat
cfp_gasdata(ConFluxPro::base_dat)
}
\seealso{
Other data formats: 
\code{\link{cfp_dat}()},
\code{\link{cfp_layered_profile}()},
\code{\link{cfp_layers_map}()},
\code{\link{cfp_profile}()},
\code{\link{cfp_soilphys}()}
}
\concept{data formats}
