% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilphys_layered.R
\name{soilphys_layered}
\alias{soilphys_layered}
\title{soilphys_layered}
\usage{
soilphys_layered(soilphys, layers_map, param, funs, id_cols)
}
\arguments{
\item{soilphys}{(dataframe) the soilphys dataframe}

\item{layers_map}{(dataframe) containing the following parameters:
\describe{
\item{upper}{upper limit of the layer in cm}
\item{lower}{lower limit of the layer in cm}
\item{layer}{the name of the layer}
\item{...}{any \code{id_cols} necessary}
}}

\item{param}{(character vector) A vector containing the names of the
variables in soilphys to be carried over}

\item{funs}{(character vector) A vector defining the type of mean to be used.
One of "arith" or "harm"}

\item{id_cols}{(character vector) A list of all columns, that, together,
uniquely identify one profile.}
}
\value{
soilphys, reduced to any \code{id_cols} and \code{param} columns and
summarised to the layers provided in \code{layers_map}
}
\description{
This function calculates (harmonic-) means of the soilphys
dataframe per layer for the flux calculation.
}
\examples{
data(soildiff)
layers_map <- data.frame(site = rep(c("site_a",
                                      "site_b"),each = 2),
                         upper = c(5,0,7,0),
                         lower = c(0,-100,0,-100),
                         layer = rep(c("HU","M1"),times = 2)
)

soildiff$depth <- (soildiff$upper + soildiff$lower) / 2

soilphys_layered(soilphys = soildiff,
                 layers_map = layers_map,
                 param = c("TPS","a"),
                 funs = c("harm","arith"),
                 id_cols = c("site"))
}
\seealso{
Other soilphys: 
\code{\link{check_soilphys}()},
\code{\link{complete_soilphys}()},
\code{\link{discretize_depth}()}
}
\concept{soilphys}
\keyword{internal}
