% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_DataUploadUI.R
\name{shiny_dataUploadUI}
\alias{shiny_dataUploadUI}
\title{Shiny Module UI for Data Upload and Processing}
\usage{
shiny_dataUploadUI(id)
}
\arguments{
\item{id}{Namespace ID for the module UI elements.}
}
\value{
A tagList containing UI output placeholders and inputs for averaging interval,
averaging statistic, and data download.
}
\description{
Creates a Shiny UI module for uploading CSV or Excel files, and specifying
flexible time averaging interval and statistic via text inputs.
This UI includes the file upload control, a text box for entering the time averaging
interval (e.g., "hour", "day", "month"), a text box for specifying the averaging
statistic (e.g., "median", "mean"), and a download button for the tidied data.
}
\examples{
if(interactive()) {
  ui <- fluidPage(
    shiny_dataUploadUI("dataUpload")
  )
  server <- function(input, output, session) {
    data <- shiny_dataUploadServer("dataUpload")
  }
}

}
