% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitmodel.R
\name{fitmodel}
\alias{fitmodel}
\title{Fit piecewise linear model}
\usage{
fitmodel(dat, alldata = FALSE, textsize = 5, title = "")
}
\arguments{
\item{dat}{data.frame output by the prepdata() function}

\item{alldata}{If FALSE (default), only the final 5 heart rate measurements
of each step are used to fit the changepoint model. If TRUE, all data are used.}

\item{textsize}{size of the breakpoint speed & pace text printed on plot (default: 5)}

\item{title}{title of plot (default: '')}
}
\value{
creates a plot showing the piecewise fit and breakpoint
}
\description{
Fit piecewise linear model
}
\examples{
# Note, files in this package are gzipped to save space. TCX files exported
# from Garmin Connect or others will not have the `.gz` extension and you
# should not use `gzfile()`.
fname = system.file(file = "extdata/2023-09-15.tcx.gz", package = "ConconiAnaerobicThresholdTest")
x1 <- prepdata(gzfile(fname), startminutes = 23.8, endminutes = 40.1,
         useDeviceSpeed = FALSE)
fitmodel(x1)
}
