% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReasonableSetConcept.R
\name{belongsToReasonableSet}
\alias{belongsToReasonableSet}
\title{Check if point is element of reasonable set}
\usage{
belongsToReasonableSet(x, v)
}
\arguments{
\item{x}{numeric vector containing allocations for each player}

\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if point belongs to reasonable set, \code{FALSE} otherwise
}
\description{
belongsToReasonableSet checks if the point is in the reasonable set
}
\examples{
library(CoopGame)
belongsToReasonableSet(x=c(1,0.5,0.5), v=c(0,0,0,1,1,1,2))

\donttest{
library(CoopGame)
v <- c(0,0,0,3,3,3,6)
belongsToReasonableSet(x=c(2,2,2),v)
#[1] TRUE
belongsToReasonableSet(x=c(1,2,4),v)
#[1] FALSE
}
}
\references{
Milnor J.W. (1953) \emph{Reasonable Outcomes for N-person Games}, Rand Corporation, Research Memorandum RM 916.

Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 21

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 43--44

Gerard-Varet L.A. and Zamir S. (1987) "Remarks on the reasonable set of outcomes in a general coalition function form game", Int. Journal of Game Theory 16(2), pp. 123--143
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
