#' @title Conditional expectation for a copula-based estimation of mixed regression models for continuous or discrete response
#' @description Compute the conditional expectation of a copula-based  2-level hierarchical model for disctrete response.
#'
#' @param object  Object of class ``CopulaGAMM`` generated by EstCopulaGAMM.
#' @param newdata List of variables for be predicted (``clu`` for clusters, ``xc`` for the copula covariates, and ``xm`` for the margins covariates). The covariates can be NULL.
#' @param m   Number of points for the numerical integration in the discrete case (default is 100).
#'
#' @return \item{mest}{Conditional expectations (conditional probabilities for the multinomial case}
#' @references Krupskii, Nasri & Remillard (2023). On factor copula-based mixed regression models
#' @author Pavel Krupskii and Bruno N. Remillard, January 20, 2023
#' @import statmod, matrixStats
#'
#' @examples
#' data(out.poisson)
#' newdata = list(clu=c(1:50),xc=rep(0.2,50),xm=rep(0.5,50))
#' pred= predictCopulaGAMM(out.poisson,newdata,m=100)
#' @export

predictCopulaGAMM=function(object,newdata,m=100)
{

  model=object$model

dismod=c("binomial", "bernoulli","poisson", "nbinom", "geometric", "multinomial")
contmod = c("gaussian","normal", "t", "laplace" , "exponential", "weibull")

mest=NULL
if(model %in% dismod){
  mest=predictDiscrete(object,newdata,m)
}else
{
  if(model %in% contmod){
    mest = predictContinuous(object,newdata)
  }
}

return(mest)
}
