% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictCopulaGAMM.R
\name{predictCopulaGAMM}
\alias{predictCopulaGAMM}
\title{Conditional expectation for a copula-based estimation of mixed regression models for continuous or discrete response}
\usage{
predictCopulaGAMM(object, newdata, m = 100)
}
\arguments{
\item{object}{Object of class ``CopulaGAMM`` generated by EstCopulaGAMM.}

\item{newdata}{List of variables for be predicted (``clu`` for clusters, ``xc`` for the copula covariates, and ``xm`` for the margins covariates). The covariates can be NULL.}

\item{m}{Number of points for the numerical integration in the discrete case (default is 100).}
}
\value{
\item{mest}{Conditional expectations (conditional probabilities for the multinomial case}
}
\description{
Compute the conditional expectation of a copula-based  2-level hierarchical model for disctrete response.
}
\examples{
data(out.poisson)
newdata = list(clu=c(1:50),xc=rep(0.2,50),xm=rep(0.5,50))
pred= predictCopulaGAMM(out.poisson,newdata,m=100)
}
\references{
Krupskii, Nasri & Remillard (2023). On factor copula-based mixed regression models
}
\author{
Pavel Krupskii and Bruno N. Remillard, January 20, 2023
}
