% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstBiCop.R
\name{EstBiCop}
\alias{EstBiCop}
\title{Parameter estimation for bivariate copula-based models with arbitrary distributions}
\usage{
EstBiCop(
  data = NULL,
  family,
  rotation = 0,
  Fx = NULL,
  Fxm = NULL,
  Fy = NULL,
  Fym = NULL
)
}
\arguments{
\item{data}{Matrix or data frame with 2 columns (X,Y). Can be pseudo-observations. If NULL, Fx and Fy must be provided.}

\item{family}{Copula family: "gaussian", "t", "clayton", "frank", "gumbel", "joe", "plackett'', "bb1", "bb6", "bb7","bb8","ncs-gaussian", "ncs-clayton", "ncs-gumbel", "ncs-frank", "ncs-joe","ncs-plackett".}

\item{rotation}{Rotation: 0 (default value), 90, 180, or 270.}

\item{Fx}{Marginal cdf function applied to X (default is NULL).}

\item{Fxm}{Left-limit of marginal cdf  function applied to X default is NULL).}

\item{Fy}{Marginal cdf function  applied to  Y (default is NULL).}

\item{Fym}{Left-limit of marginal cdf function applied to  Y (default is NULL).}
}
\value{
\item{par}{Copula parameters}

\item{family}{Copula family}

\item{rotation}{Rotation value}

\item{tauth}{Kendall's tau corresponding to the estimated parameter}

\item{tauemp}{Empirical Kendall's tau (from the multilinear empirical copula)}

\item{rhoSth}{Spearman's rho corresponding to the estimated parameter}

\item{rhoSemp}{Empirical Spearman's tau (from the multilinear empirical copula)}

\item{loglik}{Log-likelihood}

\item{aic}{Aic value}

\item{bic}{Bic value}

\item{data}{Matrix of values (could be (Fx,Fy))}

\item{F1}{Cdf of X (Fx if provided, empirical otherwise)}

\item{F1m}{Left-limit of F1 (Fxm if provided, empirical otherwise)}

\item{F2}{Cdf of Y (Fy if provided, empirical otherwise)}

\item{F2m}{Left-limit of F2 (Fym if provided, empirical otherwise)}

\item{ccdfx}{Conditional cdf of X given Y and it left limit}

\item{ccdfxm}{Left-limit of ccdfx}

\item{ccdfy}{Conditional cdf of Y given X and it left limit}

\item{ccdfym}{Left-limit of ccdfy}
}
\description{
Computes the estimation of the parameters of a copula-based model with arbitrary distributions, i.e, possibly mixtures of discrete and continuous distributions. Parametric margins are allowed. The estimation is based on a pseudo-likelihood adapted to ties.
}
\examples{
set.seed(2)
data = matrix(rpois(20,1),ncol=2)
out0=EstBiCop(data,"gumbel")

}
\references{
Nasri & Remillard (2023). Identifiability and inference for copula-based semiparametric models for random vectors with arbitrary marginal distributions. arXiv 2301.13408.

Nasri (2020). On non-central squared copulas. Statistics and Probability Letters.
}
