% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrected_standard_estimator.R
\name{shrinking}
\alias{shrinking}
\title{Linear Shrinking}
\usage{
shrinking(estCov, return_matrix = FALSE, target = NULL)
}
\arguments{
\item{estCov}{A vector whose values are an estimate autocovariance/autocorrelation function.}

\item{return_matrix}{A boolean determining whether the shrunken matrix or the corresponding vector is returned. If \code{FALSE}, it returns a vector whose values are the shrunken autocorrelation function. Defaults to \code{FALSE}.}

\item{target}{A shrinkage target matrix used in the shrinking process. This should only be used if you wish to use a specific matrix as the target.}
}
\value{
A vector with values of the shrunken autocorrelation function or the corresponding matrix (depending on \code{return_matrix}).
}
\description{
This function corrects an autocovariance/autocorrelation function estimate via linear shrinking of the autocorrelation matrix.
}
\details{
This function corrects an autocovariance/autocorrelation function estimate via linear shrinking of the autocorrelation matrix.
The shrunken autocorrelation matrix is computed as follows
\deqn{\widetilde{R} = \lambda R + (1 - \lambda)I_{p},}
where \eqn{\widetilde{R}} is the shrunken autocorrelation matrix, \eqn{R} is the original autocorrelation matrix, \eqn{\lambda \in [0, 1],} and \eqn{I_{p}} is the \eqn{p\times p} identity matrix.
\eqn{\lambda} is chosen in such a away that largest value which still results in a positive-definite matrix.
The shrunken matrix will be positive-definite.
}
\examples{
estCorr <- c(1, 0.8, 0.5, -1.2)
shrinking(estCorr)
target <- diag(length(estCorr))
shrinking(estCorr, TRUE, target)
}
\references{
Devlin, S. J., Gnanadesikan R. & Kettenring, J. R. (1975). Robust Estimation and Outlier Detection with Correlation Coefficients. Biometrika, 62(3), 531-545. 10.1093/biomet/62.3.531

Rousseeuw, P. J. & Molenberghs, G. (1993). Transformation of Non Positive Semidefinite Correlation Matrices. Communications in Statistics - Theory and Methods, 22(4), 965–984. 10.1080/03610928308831068
}
