% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_regression_estimator.R
\name{idct_1d}
\alias{idct_1d}
\title{Compute 1D Inverse Discrete Cosine Transform}
\usage{
idct_1d(X)
}
\arguments{
\item{X}{A vector of values for which the discrete cosine transform is being computed.}
}
\value{
A vector with the inverse transform values.
}
\description{
This function computes the inverse of the Type-II discrete cosine transform.
}
\details{
The Type-II inverse discrete cosine transform is computed using \link[stats:fft]{stats::fft}.
For autocovariance function estimation, the spectrum is given in the input \code{X} and then an inverse FFT is applied.

The original spectrum, \code{dct_full}, from \code{X} is obtained as follows.
First, the original sample Fourier spectrum is reconstructed using \code{dct_full <- c(X, 0, -X[-1], 0, rev(X[-1]))}. After this, an inverse FFT is applied,
\code{idct <- Re(stats::fft(dct_full, inverse = TRUE)) * (2 / length(dct_full))}, which gives the original function with additional zero-values at even indices.
The zeroes are dropped, which gives the untransformed X.
}
\examples{
X <- dct_1d(c(1, 2, 3))
idct_1d(X)
}
\references{
Ochoa-Dominguez, H. & Rao, K.R. (2019). Discrete Cosine Transform, Second Edition. CRC Press. https://doi.org/10.1201/9780203729854

endolith (2013). Fast Cosine Transform via FFT. Signal Processing Stack Exchange.
https://dsp.stackexchange.com/a/10606
}
