% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_regression_estimator.R
\name{make_pd}
\alias{make_pd}
\title{Make a Function Positive-Definite}
\usage{
make_pd(x, method.1 = TRUE)
}
\arguments{
\item{x}{A vector of numeric values of an estimated autocovariance function.}

\item{method.1}{Should method 1 be used (TRUE) or method 2 (FALSE).}
}
\value{
A vector that is the adjusted function.
}
\description{
This function can make a function positive-definite using the methods proposed by P. Hall and his coauthors.
}
\details{
This function perform positive-definite adjustments proposed by P. Hall and his coauthors.

Method 1 is as follows:
\enumerate{
\item Take the discrete Fourier cosine transform,
\eqn{\widehat{\mathcal{F}}(\theta)}.
\item Compute a modified spectrum \eqn{\widetilde{\mathcal{F}}(\theta) = \max(\widehat{\mathcal{F}}(\theta), 0)} for all sample frequencies.
\item Perform the Fourier inversion to obtain a new estimator.
}

Method 2 is as follows:
\enumerate{
\item Take the discrete Fourier cosine transform \eqn{\widehat{\mathcal{F}}(\theta)}.
\item Find the smallest frequency where its associated value in the spectral domain is negative
\deqn{\hat{\theta} = \inf\{ \theta > 0 :  \widehat{\mathcal{F}}(\theta) < 0\}.}
\item Compute a modified spectrum \eqn{\widetilde{\mathcal{F}} = \widehat{\mathcal{F}}(\theta)\textbf{1}(\theta < \hat{\theta}),}
where \eqn{\textbf{1}(A)} is the indicator function over the set \eqn{A.}
\item Perform the Fourier inversion.
}
}
\examples{
X <- c(1, 2, 3, 4)
make_pd(X)
check_pd(make_pd(X))
check_pd(make_pd(X, method.1 = FALSE))
}
\references{
Hall, P. & Patil, P. (1994). Properties of nonparametric estimators of autocovariance for stationary random fields. Probability Theory and Related Fields 99(3), 399-424. https://doi.org/10.1007/bf01199899

Hall, P., Fisher, N. I., & Hoffmann, B. (1994). On the nonparametric estimation of covariance functions. The Annals of Statistics 22(4), 2115-2134. https://doi.org/10.1214/aos/1176325774

Bilchouris, A. & Olenko, A (2025). On Nonparametric Estimation of Covariogram. Austrian Statistical Society 54(1), 112-137. https://doi.org/10.17713/ajs.v54i1.1975
}
