% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlackCox.R
\name{BlackCox}
\alias{BlackCox}
\title{Black and Cox's model}
\usage{
BlackCox(L, K = L, V0, sigma, r, gamma, t)
}
\arguments{
\item{L}{debt face value at maturity \code{t = T} (it is a constant value).}

\item{K}{positive parameter needed to calculate the safety level.}

\item{V0}{firm value at time \code{t = 0} (it is a constant value).}

\item{sigma}{volatility (constant for all t).}

\item{r}{risk-free rate (constant for all t).}

\item{gamma}{interest rate used to discount the safety level \code{Ht} (it is a constant value).}

\item{t}{a vector of debt maturity structure (it is a numeric vector).}
}
\value{
This function returns an object of class \code{data.frame} containing firm value, safety level \eqn{H(t)}
and the survival probability for each maturity. The last column is the default intensity calculated
among each interval \eqn{\Delta t}.
}
\description{
\code{BlackCox} calculates the survival probability \eqn{Q(\tau > t)} and default intensity
for each maturity according to the structural Black and Cox's model.
}
\details{
In Merton's model the default event can occurr only at debt maturity \eqn{T} while
in Black and Cox's model the default event can occurr even before.
In this model the safety level is given by the output \code{Ht}. Hitting this barrier is
considered as an erlier default. Assuming a debt face value of \code{L} at the final
maturity that coincides with the safety level in \eqn{t = T}, the safety level in \eqn{t\le T} is the
\code{K}, with \eqn{K\le L}, value discounted at back at time \eqn{t} using the interest rate
\code{gamma}, obtaining: \deqn{H(t | t\le T) = K * \exp^{- \gamma * (T- t)}}
The output parameter \code{Default.Intensity} represents the default intensity of
\eqn{\Delta t}. The firm's value \code{Vt} is calculated as in the \code{Merton} function.
}
\examples{
mod <- BlackCox(L = 0.55, K = 0.40, V0 = 1, sigma = 0.3, r = 0.05, gamma = 0.04,
t = c(0.50, 1.00, 2.00, 5.00, 7.00, 10.00, 20.00, 30.00))
mod

plot(c(0.50, 1.00, 2.00, 5.00, 7.00, 10.00, 20.00, 30.00), mod$Ht, type = 'b',
     xlab = 'Maturity', ylab = 'Safety Level H(t)', main = 'Safety level for different
     maturities', ylim = c(min(mod$Ht), 1.5), col = 'red')
abline(h = 0.55, col = 'red')
lines(c(0.50, 1.00, 2.00, 5.00, 7.00, 10.00, 20.00, 30.00), mod$Vt, xlab = 'Maturity',
      ylab = 'V(t)', main = 'Value of the Firm \n at time t', type = 's')

plot(c(0.50, 1.00, 2.00, 5.00, 7.00, 10.00, 20.00, 30.00), mod$Survival, type = 'b',
     main = 'Survival Probability for different Maturity \n (Black & Cox model)',
     xlab = 'Maturity', ylab = 'Survival Probability')

matplot(c(0.50, 1.00, 2.00, 5.00, 7.00, 10.00, 20.00, 30.00), mod$Default.Intensity,
        type = 'l', xlab = 'Maturity', ylab = 'Default Intensity')

}
\references{
David Lando  (2004) Credit risk modeling.

Damiano Brigo, Massimo Morini, Andrea Pallavicini (2013)
Counterparty Credit Risk, Collateral and Funding.
With Pricing Cases for All Asset Classes.
}
