% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gxe_analysis.R
\name{gxe_analysis_multiple}
\alias{gxe_analysis_multiple}
\title{Two-Way ANOVA for Genotype x Environment Interaction with Multiple Traits}
\usage{
gxe_analysis_multiple(
  data,
  genotype_col,
  environment_col,
  replication_col,
  trait_cols
)
}
\arguments{
\item{data}{A data frame containing the dataset with required columns.}

\item{genotype_col}{Character. Name of the genotype column.}

\item{environment_col}{Character. Name of the environment column.}

\item{replication_col}{Character. Name of the replication column.}

\item{trait_cols}{A vector of trait column names to analyze.}
}
\value{
A list containing ANOVA results for each trait.
}
\description{
This function performs a two-way ANOVA to analyze genotype and environment interactions 
for multiple traits, including replication effects. It provides separate ANOVA results 
for each specified trait in the dataset.
}
\examples{
\donttest{
set.seed(123)
data <- data.frame(
  Genotype = rep(c("G1", "G2", "G3"), each = 12),
  Environment = rep(c("E1", "E2", "E3", "E4"), times = 9),
  Replication = rep(c("R1", "R2", "R3"), times = 12),
  Trait1 = c(rnorm(36, 50, 5)),
  Trait2 = c(rnorm(36, 150, 10)),
  Trait3 = c(rnorm(36, 250, 15))
)
anova_results <- gxe_analysis_multiple(
  data = data,
  genotype_col = "Genotype",
  environment_col = "Environment",
  replication_col = "Replication",
  trait_cols = c("Trait1", "Trait2", "Trait3")
)
print(anova_results$Trait1)
}
}
\references{
Fisher, R. A. (1935). "The Design of Experiments". ISBN: 9780198522294.
}
