% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynConfMatrix.R
\name{dynConfMatrix}
\alias{dynConfMatrix}
\title{Calculate a confusion matrix}
\usage{
dynConfMatrix(predTest, depTest, cutoff = 0.5, dyn.cutoff = FALSE,
  predVal = NULL, depVal = NULL, returnClassPreds = FALSE)
}
\arguments{
\item{predTest}{Vector with predictions (real-valued or discrete)}

\item{depTest}{Vector with real class labels}

\item{cutoff}{Threshold for converting real-valued predictions into class predictions.
Default 0.5.}

\item{dyn.cutoff}{Logical indicator to enable dynamic threshold determination using
validation sample predictions. In this case, the function determines, using validation
data, the indidicence (occurrence percentage of the customer behavior or characterstic
of interest) and chooses a cutoff value so that the number of predicted positives is
equal to the number of true positives. If TRUE, then the value for the cutoff parameter
is ignored.}

\item{predVal}{Vector with predictions (real-valued or discrete). Only used if
\code{dyn.cutoff} is TRUE.}

\item{depVal}{Optional vector with true class labels for validation data. Only used
if \code{dyn.cutoff} is \code{TRUE}.}

\item{returnClassPreds}{Boolean value: should class predictions (using \code{cutoff})
be returned?}
}
\value{
A list with two elements:
\item{confMatrix}{a confusion matrix}
\item{cutoff}{the threshold value used to convert real-valued predictions to class
predictions}
\item{classPreds}{class predictions, if requested using \code{returnClassPreds}}
}
\description{
Calculates a confusion matrix for real-valued classifier predictions, with the optional
ability to dynamically determine an
incidence-based cutoff value using validation sample predictions
}
\examples{
## Load response modeling data set
data("response")
## Apply dynConfMatrix function to obtain a confusion matrix. Use validation sample
## predictions to dynamically determine an incidence-based cutoff value.
cm<-dynConfMatrix(response$test[,2],response$test[,1],dyn.cutoff=TRUE,
predVal=response$val[,2],depVal=response$val[,1])
print(cm)

}
\references{
Witten, I.H., Frank, E. (2005): Data Mining: Practical Machine Learning
Tools and Techniques, Second Edition. Chapter 5. Morgan Kauffman.
}
\seealso{
\code{\link{dynAccuracy}}, \code{\link{confMatrixMetrics}}
}
\author{
Koen W. De Bock, \email{kdebock@audencia.com}
}
