/*
 * BootstrapSelector.h
 *
 *  Created on: Nov 17, 2010
 *      Author: msuchard
 */

#ifndef BOOTSTRAPSELECTOR_H_
#define BOOTSTRAPSELECTOR_H_

#include <set>

#include "AbstractSelector.h"

namespace bsccs {

class BootstrapSelector : public AbstractSelector {
public:
	BootstrapSelector(
			int inReplicates,
			std::vector<int> inIds,
			SelectorType inType,
			long inSeed,
    	    loggers::ProgressLoggerPtr _logger,
	    	loggers::ErrorHandlerPtr _error,
			std::vector<double>* wtsExclude,
			std::vector<double>* weightsOriginal);

	virtual ~BootstrapSelector();

	virtual void permute();

	virtual void getWeights(int batch, std::vector<double>& weights);

	virtual void getComplement(std::vector<double>& weights);
	
	AbstractSelector* clone() const;

private:
	std::multiset<int> selectedSet;
	std::vector<int> indicesIncluded;
	std::vector<double>* weightsOriginal;
};

} // namespace

#endif /* BOOTSTRAPSELECTOR_H_ */
