% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlite.R
\name{saveSQLite}
\alias{saveSQLite}
\title{Save R data frame to SQLite file.
This function saves a data frame to an SQLite database file. It can create
indices on specified columns for faster querying. The database file is stored
in the task's binary directory.}
\usage{
saveSQLite(
  object,
  task,
  type,
  subdir = NULL,
  dirCreate = TRUE,
  index = NULL,
  tableName = "data",
  overwrite = FALSE,
  append = FALSE,
  row.names = FALSE
)
}
\arguments{
\item{object}{data.frame to serialize.}

\item{task}{Object of class \code{\link{D4TAlinkTask}}, as created by \code{\link{initTask}}.}

\item{type}{Filename type. If the type is an array, the cocatenation of the elements is used with separator"-". Filenames have the form [task name]_[type].[ext]}

\item{subdir}{(optional) Subdirectory.}

\item{dirCreate}{Logical, if TRUE (by default) the directory is created.}

\item{index}{character vector of column names to create indices on.}

\item{tableName}{name of the table in the SQLite database.}

\item{overwrite}{if \code{TRUE}, overwrite existing table.}

\item{append}{if \code{TRUE}, append to existing table.}

\item{row.names}{if \code{TRUE}, save row names as a column.}
}
\value{
The file name invisibly.
}
\description{
Save R data frame to SQLite file.
This function saves a data frame to an SQLite database file. It can create
indices on specified columns for faster querying. The database file is stored
in the task's binary directory.
}
\examples{
\dontrun{
task <- loadTask("myproject","mypackage","mytask")
# create a sample data frame
df <- data.frame(a = 1:5, b = letters[1:5])
# save it to SQLite
fn <- saveSQLite(df, task, "testdb",tableName="table1",
                 index = c("a"))
# read it back
df_loaded <- readSQLite(task,"testdb",tableName="table1")
# print the loaded data frame
print(df_loaded)
# add second data frame
df2 <- data.frame(a = 6:10, b = letters[6:10])
saveSQLite(df2, task,"testdb",tableName="table2")
# query the data
query_result <- querySQLite("SELECT * FROM table2 WHERE a > 8",
                            task,"testdb")
print(query_result)                           
#' # append to the first table
saveSQLite(df2, task,"testdb",tableName="table1",append=TRUE)
# read the updated table
df_loaded <- readSQLite(task,"testdb",tableName="table1")
# print the updated data frame
print(df_loaded)
# cleanup
unlink(fn)
} 
}
