% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_rates.R
\name{get_clado_rate}
\alias{get_clado_rate}
\title{Calculate cladogenesis rate}
\usage{
get_clado_rate(
  lac,
  hyper_pars,
  num_spec,
  K,
  A,
  trait_pars = NULL,
  island_spec = NULL
)
}
\arguments{
\item{lac}{A numeric with the per capita cladogenesis rate.}

\item{hyper_pars}{A named list of numeric hyperparameters for the rate
calculations as returned by \code{\link{create_hyper_pars}()}:
\itemize{
  \item{[1]: is d the scaling parameter for exponent for calculating
  cladogenesis rate}
  \item{[2]: is x the exponent for calculating extinction rate}
}}

\item{num_spec}{A numeric with the current number of species.}

\item{K}{A numeric with carrying capacity.}

\item{A}{A numeric value for island area at a given point in time.}

\item{trait_pars}{A named list containing diversification rates considering
  two trait states created by \code{\link{create_trait_pars}}:
\itemize{
  \item{[1]:A numeric with the per capita transition rate with state 1}
  \item{[2]:A numeric with the per capita immigration rate with state 2}
  \item{[3]:A numeric with the per capita extinction rate with state 2}
  \item{[4]:A numeric with the per capita anagenesis rate with state 2}
  \item{[5]:A numeric with the per capita cladogenesis rate with state 2}
  \item{[6]:A numeric with the per capita transition rate with state 2}
  \item{[7]:A numeric with the number of species with trait state 2 on
   mainland}
}}

\item{island_spec}{Matrix with current state of simulation containing number
of species.}
}
\description{
Internal function.
Calculates the cladogenesis rate given the current number of
species in the system, the carrying capacity and the per capita cladogenesis
rate
}
\author{
Pedro Neves, Joshua Lambert, Shu Xie
}
\keyword{internal}
