% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMOCLES_ML.R
\name{DAMOCLES_ML}
\alias{DAMOCLES_ML}
\title{Maximization of the loglikelihood under the DAMOCLES model}
\usage{
DAMOCLES_ML(
  phy,
  pa,
  initparsopt,
  idparsopt = 1:length(initparsopt),
  parsfix = NULL,
  idparsfix = NULL,
  idparsequal = NULL,
  pars2 = c(0.001, 1e-04, 1e-05, 1000),
  optimmethod = "subplex",
  pchoice = 0,
  edgeTList = NULL,
  methode = "analytical",
  model = 0,
  verbose = FALSE
)
}
\arguments{
\item{phy}{phylogeny in phylo format}

\item{pa}{presence-absence table.\cr The first column contains the labels of
the species (corresponding to the tip labels in the phylogeny.\cr The second
column contains the presence (1) or absence (0) of species in the local
community.}

\item{initparsopt}{The initial values of the parameters that must be
optimized}

\item{idparsopt}{The ids of the parameters that must be optimized, e.g. 1:2
for extinction rate, and offset of immigration rate The ids are defined as
follows: \cr id == 1 corresponds to mu (extinction rate) \cr id == 2
corresponds to gamma_0 (offset of immigration rate) \cr id == 3 corresponds
to gamma_1 (parameter controlling decline in immigration rate with time)}

\item{parsfix}{The values of the parameters that should not be optimized.
See idparsfix.}

\item{idparsfix}{The ids of the parameters that should not be optimized,
e.g. c(1,3) if mu and gamma_1 should not be optimized, but only gamma_0. In
that case idparsopt must be c(2). The default is to fix all parameters not
specified in idparsopt.}

\item{idparsequal}{The ids of the parameters that should be set equal to the 
first parameter of the same type.}

\item{pars2}{Vector of settings: \cr
\code{pars2[1]} sets the relative tolerance in the parameters \cr \cr
\code{pars2[2]} sets the relative tolerance in the function \cr \cr
\code{pars2[3]} sets the absolute tolerance in the parameters \cr \cr
\code{pars2[4]} sets the maximum number of iterations}

\item{optimmethod}{Method used in optimization of the likelihood. Current
default is 'subplex'. Alternative is 'simplex' (default of previous version)}

\item{pchoice}{sets the p-value to optimize: \cr
pchoice == 0 corresponds to the sum of p_0f + p_1f \cr
pchoice == 1 corresponds to p_0f \cr
pchoice == 2 corresponds to p_1f \cr}

\item{edgeTList}{list of edge lengths that need to be succesively pruned; if
not specified, it will computed using compute_edgeTList}

\item{methode}{method used to solve the ODE. Either 'analytical' for the analytical
solution, 'Matrix' for matrix exponentiation using package Matrix or 'expm' using
package 'expm' or any of the numerical solvers, used in deSolve.}

\item{model}{model used. Default is 0 (standard null model). Other options are 1 (binary traits)
2 (trinary environmental trait) or 3 (diversity-dependent colonization - beta version)}

\item{verbose}{Whether intermediate output should be printed. Default is FALSE.}
}
\value{
\item{mu}{ gives the maximum likelihood estimate of mu}
\item{gamma_0}{ gives the maximum likelihood estimate of gamma_0}
\item{gamma_1}{ gives the maximum likelihood estimate of gamma_1}
\item{loglik}{ gives the maximum loglikelihood}
\item{df}{ gives the number of estimated parameters, i.e. degrees of feedom} 
\item{conv}{ gives a message on convergence of optimization; conv = 0 means convergence}
}
\description{
This function computes the maximum likelihood estimates of the parameters of
the DAMOCLES model for a given phylogeny and presence-absence data.  It also
outputs the corresponding loglikelihood that can be used in model
comparisons.
}
\details{
The output is a dataframe containing estimated parameters and maximum
loglikelihood.
}
\references{
Pigot, A.L. & R.S. Etienne (2015). A new dynamic null model for
phylogenetic community structure. Ecology Letters 18: 153-163.
}
\seealso{
\code{\link{DAMOCLES_loglik}} \code{\link{DAMOCLES_sim}}
}
\author{
Rampal S. Etienne
}
\keyword{models}
