\name{predictive.checks.DDPstar}
\alias{predictive.checks.DDPstar}
\title{
Posterior predictive checks.
}
\description{
Implements posterior predictive checks for objects of class \code{DDPstar} as produced by function \code{DDPstar}.
}
\usage{
predictive.checks.DDPstar(object, statistics = c("min", "max", "kurtosis", "skewness"), 
  devnew = TRUE, ndensity = 512, trim = 0.025)
}
\arguments{
  \item{object}{An object of class \code{DDPstar} as produced by function \code{DDPstar}.}
  \item{statistics}{Character vector. Statistics to be used for the posterior predictive checking. By default, "min", "max", "kurtosis" and "skewness".}
  \item{devnew}{A logical value. If TRUE, each plot is depicted in a new graphic device.}
  \item{ndensity}{An integer giving the number of equally spaced points at which the density of the response variable and of the simulated datasets from the posterior predictive distribution (see more on Details) is to be estimated (for more details see the help of the function \code{density} in the \code{stats} package)}
  \item{trim}{the fraction (0 to 0.5) of (simulated) test statistics to be trimmed.}
}
\details{
Compares a selected test statistic computed based on the observed response variable against the same test statistics computed based on simulated data from the posterior predictive distribution of the response variable obtained using a DDPstar model. The following graphics are depicted: (1) histograms of the desired statistics computed from simulated datasets (nsave of them) from the posterior predictive distribution of the response variable. In these plots, the estimated statistics from the observed response variable are also depicted. (2) Kernel density estimates computed computed from simulated datasets (nsave of them) from the posterior predictive distribution of the response variable. In these plots, the kernel density estimate of the observed response variable is also depicted. For a detailed discussion about predictive checks, see Gabry et al. (2019).
}
\value{
As a result, the function provides a list with the following components:
\item{yrep}{numeric matrix. Each column of the matrix (there are nsave of them) corresponds to a dataset generated from the posterior predictive distribution of the of the response variable.}
\item{y}{numeric vector containing the observed response variable.}
}
\references{
Gabry, J., Simpson, D., Vehtari, A., Betancourt, M., and Gelman, A. (2019). Visualization in Bayesian workflow. Journal of the Royal Statistical Society, Series A, 182, 1-14.
}
\seealso{
\code{\link{DDPstar}}
}
\examples{
library(DDPstar)
data(dde)
dde$GAD <- dde$GAD/7 # GAD in weeks
\donttest{
set.seed(10) # For reproducibility
fit_dde <- DDPstar(formula = GAD ~ f(DDE, bdeg = 3, nseg = 20, pord = 2, atau = 1, btau = 0.005), 
  data = dde, mcmc = list(nburn = 20000, nsave = 15000, nskip = 1), 
  prior = list(a = 2, b = 0.5, aalpha = 2, balpha = 2, L = 20), 
  standardise = TRUE, compute.lpml = TRUE, compute.WAIC = TRUE)
op <- par(mfrow = c(2,3))
predictive.checks.DDPstar(fit_dde)
par(op)
}
\dontshow{
set.seed(10) # For reproducibility
fit_dde <- DDPstar(formula = GAD ~ f(DDE, bdeg = 3, nseg = 20, pord = 2, atau = 1, btau = 0.005), 
data = dde, mcmc =list(nburn = 20, nsave = 15, nskip = 1), 
prior = list(a = 2, b = 0.5, aalpha = 2, balpha = 2, L = 20), 
standardise = TRUE, compute.lpml = TRUE, compute.WAIC = TRUE)
op <- par(mfrow = c(2,3))
predictive.checks.DDPstar(fit_dde)
par(op)
}
}