% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiScales.R
\docType{class}
\name{DexiScale-class}
\alias{DexiScale-class}
\alias{DexiScale}
\title{DexiScale}
\description{
\code{DexiScale} is a base RC class representing value scales in R.
}
\details{
A value scale defines the type and set of values that can be assigned to some \link{DexiAttribute}.
\link{DexiScale} is a base scale class that defines fields and methods common to all scales:
\itemize{
\item whether or not the scale is preferentially ordered (and in which direction),
\item scale type (discrete or continuous),
\item the number of scale elements, if countable,
\item partition of scale elements in three preferential classes: \code{"bad"}, \code{"good"} and \code{"none"},
\item helper methods \code{value_index()} and \code{full_range()}.
}

DEXiR implements two other scale classes derived from \code{DexiScale}:
\link{DexiContinuousScale} and \link{DexiDiscreteScale}.
}
\section{Fields}{

\describe{
\item{\code{order}}{character. Preferential order of the scale.
Possible values: \code{"ascending"}, \code{"descending"} or \code{"none"}.}
}}

\section{Methods}{

\describe{
\item{\code{count()}}{Return the number of scale elements.
Equal to \code{NA} for \code{DexiScale}, \code{0} for \code{DexiContinuousScale}, and
equal to \code{nvals >= 0} for \code{DexiDiscreteScale}.}

\item{\code{equal(scl)}}{Check if this scale is equal to scale \code{scl}. Needed for attribute linking.}

\item{\code{full_range()}}{Return the vector that represents the full range of values on this scale.
Equal to \code{NA} for \code{DexiScale} and \code{DexiContinuousScale},
and \code{1 : scale$nvals} for \code{DexiDiscreteScale}.}

\item{\code{initialize(order = EnumOrder, ...)}}{Initialize a \code{DexiScale} object.}

\item{\code{is_continuous()}}{Logical: Is this scale continuos?}

\item{\code{is_discrete()}}{Logical: Is this scale discrete?}

\item{\code{to_string()}}{Return a string representation of this scale for printing.}

\item{\code{value_index(value)}}{Find the index of \code{value} (character(1)) on this scale.
Equal to \code{NA} for \code{DexiScale} and \code{DexiContinuousScale}.
With \code{DexiDiscreteScale} objects, it returns a numeric index or \code{NA}
of \code{value} in \code{scale$values}.}

\item{\code{value_quality(value)}}{Return the quality (preferential class) of \code{value} on this scale:
one of the strings \code{"bad"}, \code{"none"} or \code{"good"}.
Always \code{"none"} for \code{DexiScale} and scales with \code{order = "none"}.}

\item{\code{verify()}}{Check the correctnes of this scale object and its fields.
Result: \code{error()} or \code{TRUE}.}
}}

