% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiFunctions.R
\name{dexi_index}
\alias{dexi_index}
\title{dexi_index}
\usage{
dexi_index(vec, dim)
}
\arguments{
\item{vec}{Integer vector, representing arguments of some decision rule.}

\item{dim}{Integer vector, representing dimensions of the corresponding decision space.
Assumptions: \code{length(vec) == length(dim)} and, for each \code{i},
\verb{1 <= vec[[i]] <= dim[[i]]}.}
}
\value{
Integer, index of \code{vec}.
}
\description{
Return the index of argument vector \code{vec} in the decision space \code{dim}.
The index is calculated according to DEXi's sorting rules, which are different to R's.
}
\examples{
dexi_index(c(1,1,1), c(2,2,3))
dexi_index(c(1,1,2), c(2,2,3))
dexi_index(c(1,2,3), c(2,2,3))

}
