% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfiMI.R
\name{DfiMI}
\alias{DfiMI}
\title{Distributed Full-information Multiple Imputation (DfiMI)}
\description{
  Perform multiple imputation of the response variable Y via R independent
  runs and M stochastic imputations per run. Missing values in Y are imputed by means of
  (intercept-adjusted) OLS regression on the complete predictors.
}
\usage{
DfiMI(data, R, M)
}
\arguments{
  \item{data}{
    A  data frame  whose  first column  contains the response variable  Y  (possibly with  NAs)
    and whose remaining columns contain numeric predictors.
  }
  \item{R}{
    Positive integer -- number of simulation runs used to stabilise the coefficient estimates.
  }
  \item{M}{
    Positive integer -- number of multiple imputations drawn within each run.
  }
}
\details{
  This function implements a distributed full-information multiple imputation (DfiMI) approach.
  It iteratively imputes missing values in the response variable  Y  using OLS regression
  on the complete predictors. The process is repeated  R  times to stabilise the coefficient
  estimates, and within each run,  M  imputations are performed to account for the uncertainty
  in the imputation process.
}
\value{
  A named list with components:
  \describe{
    \item{Yhat}{
      Numeric vector -- the original  Y  with missing values replaced by their imputed counterparts.
    }
    \item{betahat}{
      Numeric vector -- final regression coefficients (including intercept).
    }
  }
}
\examples{
set.seed(123)
n  <- 60
data <- data.frame(
  Y  = c(rnorm(n - 10), rep(NA, 10)),  # 50 observed + 10 missing
  X1 = rnorm(n),
  X2 = rnorm(n)
)

res <- DfiMI(data, R = 3, M = 5)
head(res$Yhat)   # inspect imputed Y
res$betahat      # inspect coefficients
}
