#' A function computing an estimate of the shifted-MMD.
#'
#' A function computing the U-statistic (12). This serves as an estimator
#' of the shifted-MMD defined in Section 3.2 of \insertCite{BB2025DRPT;textual}{DRPT}.
#'
#' @param X A numeric vector containing the first sample.
#' @param Y A numeric vector containing the second sample.
#' @param r A function specifying the hypothesised density ratio.
#' @param kernel A function defining the kernel to be used for the U-statistic.
#'
#' @return The value of the U-statistic (12).
#' @export
#'
#' @references \insertRef{BB2025DRPT}{DRPT}
#'
#' @examples
#' n = 250; m = 250; d = 2
#' r = function(x,y) {
#'   return(4*x*y)
#'    }
#'
#' gaussian.kernel = function(x, y, lambda = 1){
#'      return(lambda^(-d) * exp(-sum(((x - y) ^ 2) / (lambda ^ 2))))
#'      }
#'
#' X = as.matrix(cbind(runif(n, 0, 1), runif(n, 0, 1)))
#' Y = as.matrix(cbind(rbeta(m, 0.5, 0.3), rbeta(m, 0.5, 0.4)))
#'
#' shiftedMMD(X,Y, r, gaussian.kernel)

shiftedMMD = function(X, Y, r, kernel){
  return(compute_mmd_C(X, Y, r, kernel))
}
