% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpalConnection.R
\name{dsHasResource,OpalConnection-method}
\alias{dsHasResource,OpalConnection-method}
\title{Verify Opal resource}
\usage{
\S4method{dsHasResource}{OpalConnection}(conn, resource)
}
\arguments{
\item{conn}{\code{\link{OpalConnection-class}} class object.}

\item{resource}{The fully qualified name of the resource.}
}
\value{
TRUE if the resource exists.
}
\description{
Verify Opal resource exist and can be accessible for performing DataSHIELD operations.
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "administrator", "password", "https://opal-demo.obiba.org")
dsHasResource(con, "test.CNSIM")
dsDisconnect(con)
}

}
