% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{sim_dte}
\alias{sim_dte}
\title{Simulates survival times for a delayed treatment effect (DTE) scenario, where the treatment group experiences a delayed onset of benefit. Control and treatment groups are generated under exponential or Weibull distributions.}
\usage{
sim_dte(
  n_c,
  n_t,
  lambda_c,
  delay_time,
  post_delay_HR,
  dist = "Exponential",
  gamma_c = NULL
)
}
\arguments{
\item{n_c}{The number of patients in the control group}

\item{n_t}{The number of patients in the treatment group}

\item{lambda_c}{The baseline hazard rate for the control group}

\item{delay_time}{The length of delay before treatment effect begins}

\item{post_delay_HR}{The hazard ratio after the delay period}

\item{dist}{The distribution for the control group; must be one of "Exponential" (default) or "Weibull"}

\item{gamma_c}{The shape parameter for the Weibull distribution (only used if \code{dist = "Weibull"})}
}
\value{
A data frame with two columns:
\item{time}{Simulated survival times}
\item{group}{Group assignment: "Control" or "Treatment"}
Class: \code{data.frame}
}
\description{
Simulates survival times for a delayed treatment effect (DTE) scenario, where the treatment group experiences a delayed onset of benefit. Control and treatment groups are generated under exponential or Weibull distributions.
}
\examples{
set.seed(123)
sim_data <- sim_dte(n_c = 10, n_t = 10, lambda_c = 0.1,
                    delay_time = 6, post_delay_HR = 0.6)
head(sim_data)

}
