% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conduct.R
\name{conduct}
\alias{conduct}
\title{Computes the hazard ratio between post- and pre-separation periods, provides the 95\% Bayesian credible interval,
and makes a Go/No-Go decision based on the trial data. This function is intended for interim and final analyses
in two-arm survival trials with delayed treatment effects.}
\usage{
conduct(
  data_E,
  data_C,
  median.1,
  median.2,
  gprior.E_1 = NULL,
  gprior.E_2 = NULL,
  L,
  U,
  trunc.para = c(1, 1),
  lambda,
  gamma,
  nmax,
  S_likely = (L + U)/2,
  value = FALSE
)
}
\arguments{
\item{data_E}{A data frame containing the survival data for the experimental (treatment) arm. The first column should be the observed survival times, and the second column should be the event indicator (1 = event, 0 = censored).}

\item{data_C}{A data frame containing the survival data for the control arm. The format is the same as data_E: first column for observed time, second column for status (1 = event, 0 = censored).}

\item{median.1}{Numeric. The overall median survival time for the standard-of-care (SOC) arm.}

\item{median.2}{Numeric. The overall median survival time for the experimental arm.}

\item{gprior.E_1}{Optional. A numeric vector of length two specifying the shape and scale parameters of the inverse-gamma prior for the pre-separation mean survival time (i.e., 1/hazard rate). If NULL, the default is  \code{c(4,3/log(2)*median.1)}}

\item{gprior.E_2}{Optional. A numeric vector of length two specifying the shape and scale parameters of the inverse-gamma prior for the post-separation mean survival time (i.e., 1/hazard rate). If NULL, the default is  \code{c(4,6/log(2)*median.1)}}

\item{L}{Numeric. The lower bound of the delayed treatment effect (DTE) separation timepoint.}

\item{U}{Numeric. The upper bound of the delayed treatment effect (DTE) separation timepoint.}

\item{trunc.para}{Numeric vector of length two. Specifies the shape and scale parameters of the truncated Gamma prior for the DTE timepoint.}

\item{lambda}{Numeric. Weighting parameter used in the posterior decision function:\eqn{1-\lambda(n/N)^{\gamma}}}

\item{gamma}{Numeric. Exponent parameter used in the posterior decision function:\eqn{1-\lambda(n/N)^{\gamma}}}

\item{nmax}{Integer. Maximum sample size per arm.}

\item{S_likely}{Numeric. The most likely value of the DTE separation timepoint. Defaults to the midpoint of \code{L} and \code{U}}

\item{value}{If TRUE, returns posterior means, 95\% credible intervals, and event rates. Default is FALSE.}
}
\value{
A list with the following components:
\item{posterior_mean}{Posterior mean of the hazard ratio (post- / pre-separation).}
\item{credible_interval}{95\% Bayesian credible interval for the hazard ratio.}
\item{event_rates}{Event rates for the experimental arm, control arm, and overall.}
\item{decision}{
One of the following trial decisions based on observed data:
\describe{
\item{Go}{Trial proceeds to next stage.}
\item{No-Go}{Trial stops early for futility.}
\item{Reject Null Hypothesis}{Final analysis leads to rejecting H0.}
\item{Not Reject Null Hypothesis}{Final analysis fails to reject H0.}
}
}
}
\description{
Computes the hazard ratio between post- and pre-separation hazard rates, along with the 95\% Bayesian credible interval. Based on the user-supplied survival data, the function also provides a Go/No-Go decision for interim or final analysis in two-arm survival trials with delayed treatment effects
}
\examples{
\donttest{
conduct(data_E, data_C, median.1 = 2.8, median.2 = 3.5, L = 2, U = 2.5,
        trunc.para = c(1, 1), lambda = 0.95, gamma = 1, nmax = 63, S_likely = 2.3)
        }
}
