% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_fun.R
\name{event_fun}
\alias{event_fun}
\title{Return expected event number at interim analysis and final analysis.}
\usage{
event_fun(
  median.1,
  median.2,
  S_likely = (L + U)/2,
  n.interim,
  rate,
  FUP,
  n.sim = 1000,
  seed = NULL
)
}
\arguments{
\item{median.1}{Numeric. The overall median survival time for SOC.}

\item{median.2}{Numeric. The overall median survival time for the experimental arm.}

\item{S_likely}{Numeric. The most likely separation time. Defaults to the midpoint of \code{L} and \code{U}.}

\item{n.interim}{A vector of sample sizes per arm at each interim analysis.
\itemize{
\item Each element except the last represents an interim sample size per arm.
\item The final element is the total sample size N per arm.
}}

\item{rate}{Numeric value. Patient accrual rate (e.g., patients per month).}

\item{FUP}{Numeric value. Duration of follow-up. Default is 6 month/year in the context.}

\item{n.sim}{Integer. Number of simulations to generate. Default is 1000.}

\item{seed}{Optional integer. If provided, sets the seed for reproducibility.}
}
\value{
A data frame with two columns:
the first column indicates the stage label,
and the second column contains the expected number of events for each stage.
}
\description{
Based on the overall median times (median.1, median.2), the most likely separation timepoint, accrual rate and follow-up duration, this function will return the expected number of events in total at each interim analysis and final analysis based on the simulations.
}
\examples{
\donttest{
result <- event_fun(
median.1 = 2.8,
median.2 = 3.5,
S_likely = 2.1,
n.interim = c(28,40),
rate = 6,
FUP = 6
)
}
}
