% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getoc_2arm_piecewise.R
\name{getoc_2arm_piecewise}
\alias{getoc_2arm_piecewise}
\title{Compute Operating Characteristics for Two-Arm Piecewise Exponential Designs}
\usage{
getoc_2arm_piecewise(
  median.true,
  gprior.E_1 = NULL,
  gprior.E_2 = NULL,
  lambda,
  gamma,
  n.interim,
  L,
  U,
  S_likely = (L + U)/2,
  Uniform = FALSE,
  trunc.para,
  rate,
  FUP = 6,
  nsim = 1000,
  track = FALSE,
  seed = NULL
)
}
\arguments{
\item{median.true}{A numeric vector of length two.
\itemize{
\item The first element is the overall median survival time (in months) for the standard-of-care (SOC) arm under the null hypothesis.
\item The second element is the overall median survival time for the experimental arm.
}}

\item{gprior.E_1}{Optional. A numeric vector of length two specifying the shape and scale parameters of the inverse-gamma prior for the pre-separation mean survival time (i.e., 1/hazard rate). If NULL, the default is  \code{c(4,3/log(2)*median.true[1])}}

\item{gprior.E_2}{Optional. A numeric vector of length two specifying the shape and scale parameters of the inverse-gamma prior for the post-separation mean survival time (i.e., 1/hazard rate). If NULL, the default is  \code{c(4,6/log(2)*median.true[1])}}

\item{lambda}{Numeric. The tuning parameter \eqn{\lambda} in the decision boundary function \eqn{1 - \lambda \cdot (n/N)^\gamma}.}

\item{gamma}{Numeric. The tuning parameter \eqn{\gamma} in the decision boundary function \eqn{1 - \lambda \cdot (n/N)^\gamma}.}

\item{n.interim}{A numeric vector. Specifies the sample sizes per arm at each analysis. The last element represents the final sample size per arm.}

\item{L}{Numeric. Lower bound of the delayed treatment effect (DTE) separation time.}

\item{U}{Numeric. Upper bound of the DTE separation time.}

\item{S_likely}{Numeric. The most likely value of the separation time. Defaults to the midpoint of \code{L} and \code{U}.
Default is the midpoint of \code{L} and \code{U}.}

\item{Uniform}{Logical value.
\itemize{
\item \code{Default} FALSE. The truncated gamma distribution for the separation time will be utilized.
\item \code{If TRUE} the average type I error and power are calculated based on 20 evenly divided points in the interval \eqn{[L,U]}.
}}

\item{trunc.para}{Vector value with two elements. The first element is the shape parameter for the truncated gamma prior and the second one is the scale parameter.}

\item{rate}{Numeric. Patient accrual rate (e.g., patients per month).}

\item{FUP}{Numeric value. Duration of follow-up. Default is 6 month/year in the context.}

\item{nsim}{Integer. Number of simulations to generate. Default is 10000.}

\item{track}{Logical value.
\itemize{
\item \code{Default} FALSE
\item \code{If TRUE}, prints progress updates every 1000 simulations.
}}

\item{seed}{Optional integer. If provided, sets the seed for reproducibility.}
}
\value{
A list with the following components:
\describe{
\item{earlystop}{Numeric. The proportion of simulated trials that stopped early
due to futility or predefined stopping rules.}

\item{reject}{Numeric. The proportion of trials in which the null hypothesis ($H_0$) was rejected.}

\item{average.patients}{Numeric. The average number of patients enrolled across all simulated trials.}

\item{trial.duration}{Numeric. The average total duration of the trial (in months), including follow-up.}
}
}
\description{
Computes the operating characteristics (e.g., type I error, power, and other performance metrics) of a two-arm survival trial design under the DTE-BOP2 framework with delayed treatment effect, based on a piecewise exponential model. This function is typically used after selecting design parameters (e.g., lambda, gamma) to assess the statistical properties of the proposed design.
}
\examples{
# Define trial parameters
median.1 <- 6
median.2 <- 9
trunc.para <- c(1, 1)
rate <- 3
FUP <- 9
n.interim <- c(30, 50)  # Each arm: 30 pts at interim, 50 pts at final
# Run operating characteristics computation
getoc_2arm_piecewise(median.true = c(median.1, median.2),
Uniform = FALSE,lambda = 0.9,gamma = 1,n.interim = n.interim,
  L = 3,U = 3,S_likely = 3,FUP = FUP,trunc.para = trunc.para,
  rate = rate,nsim = 1)
}
