% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtrunc_gamma.R
\name{rtrunc_gamma}
\alias{rtrunc_gamma}
\title{Generate Random Variables from a Truncated Gamma Distribution.}
\usage{
rtrunc_gamma(n, L, U, shape, scale)
}
\arguments{
\item{n}{Integer. Number of random variables to generate.}

\item{L}{Numeric. Lower bound of the truncation interval. Must satisfy \code{L <= U}.}

\item{U}{Numeric. Upper bound of the truncation interval. Must satisfy \code{U >= L}.}

\item{shape}{Numeric. Shape parameter of the underlying gamma distribution.}

\item{scale}{Numeric. Scale parameter of the underlying gamma distribution.}
}
\value{
A numeric vector of length \code{n}, containing random variables drawn from a gamma distribution truncated to the interval \code{[L, U]}.
}
\description{
Simulates random variables from a truncated gamma distribution, where the gamma distribution is bounded between user-specified lower and upper limits. This function is typically used to define priors (e.g., for the separation time in delayed treatment effect models).
}
\examples{
rtrunc_gamma(10, 1, 1, 1, 1)
}
