/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.dataengine.utilities;

import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.IncorrectTypeException;

public class DSITypeUtilities {
    public static boolean outputCharStringData(String string, DataWrapper dataWrapper, long l, long l2) {
        try {
            return DSITypeUtilities.outputString(string, dataWrapper, l, l2, 1);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            return true;
        }
    }

    public static boolean outputVarCharStringData(String string, DataWrapper dataWrapper, long l, long l2) {
        try {
            return DSITypeUtilities.outputString(string, dataWrapper, l, l2, 12);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            return true;
        }
    }

    public static boolean outputLongVarCharStringData(String string, DataWrapper dataWrapper, long l, long l2) {
        try {
            return DSITypeUtilities.outputString(string, dataWrapper, l, l2, -1);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            return true;
        }
    }

    public static boolean outputBinary(byte[] byArray, DataWrapper dataWrapper, long l, long l2) {
        try {
            return DSITypeUtilities.outputBytes(byArray, dataWrapper, l, l2, -2);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            return true;
        }
    }

    public static boolean outputVarBinary(byte[] byArray, DataWrapper dataWrapper, long l, long l2) {
        try {
            return DSITypeUtilities.outputBytes(byArray, dataWrapper, l, l2, -3);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            return true;
        }
    }

    public static boolean outputLongVarBinary(byte[] byArray, DataWrapper dataWrapper, long l, long l2) {
        try {
            return DSITypeUtilities.outputBytes(byArray, dataWrapper, l, l2, -4);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            return true;
        }
    }

    public static boolean outputString(String string, DataWrapper dataWrapper, long l, long l2, int n) throws IncorrectTypeException {
        assert (1 == n || 12 == n || -1 == n || -8 == n || -9 == n || -10 == n);
        assert (l >= 0L && l <= Integer.MAX_VALUE);
        if (string != null) {
            String string2 = string.substring((int)l);
            if (l2 == -1L) {
                dataWrapper.setData(n, string2);
                return false;
            }
            int n2 = Math.min((int)l2, string2.length());
            dataWrapper.setData(n, string2.substring(0, n2));
            return n2 < string2.length();
        }
        dataWrapper.setNull(n);
        return false;
    }

    public static boolean outputBytes(byte[] byArray, DataWrapper dataWrapper, long l, long l2, int n) throws IncorrectTypeException {
        assert (-2 == n || -3 == n || -4 == n);
        assert (0L <= l);
        if (byArray != null) {
            boolean bl;
            byte[] byArray2;
            long l3 = byArray.length;
            long l4 = l3 - l;
            if (-1L == l2 || l4 <= l2) {
                byArray2 = new byte[(int)l4];
                System.arraycopy(byArray, (int)l, byArray2, 0, (int)l4);
                bl = false;
            } else {
                byArray2 = new byte[(int)l2];
                System.arraycopy(byArray, (int)l, byArray2, 0, (int)l2);
                bl = true;
            }
            dataWrapper.setData(n, byArray2);
            return bl;
        }
        dataWrapper.setNull(n);
        return false;
    }
}

