% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeRezende.Ferreira.5F.R
\name{DRF.5F.tFix}
\alias{DRF.5F.tFix}
\title{Estimation of the De Rezende-Ferreira 5 Factor model's parameters with fixed \eqn{\ \tau}}
\usage{
DRF.5F.tFix(rate, maturity, fixed_tau1, fixed_tau2)
}
\arguments{
\item{rate}{Vector or matrix of class "zoo", which contains interest rates}

\item{maturity}{Vector of class "numeric", wich contains the maturities}

\item{fixed_tau1}{Decaying parameter of class "numeric" (Slope)}

\item{fixed_tau2}{Decaying parameter of class "numeric" (Curvature)}
}
\value{
An object of class "zoo", that contains
\eqn{\ \left (\beta_{0t},\ \beta_{1t},\ \beta_{2t},\ \beta_{3t},\ \beta_{4t},\ \tau_{1t},\ \tau_{2t},\ SSR_{t},\ R^{2}_{t} \right)}
}
\description{
The command estimates the parameters of the De Rezende-Ferreira 5 Factor model
             using fixed \eqn{\ \tau_{1}} and \eqn{\ \tau_{2}}
}
\examples{
#
# De Rezende-Ferreira 5F model on the Indian Data-Set
#

data(ZC_India)
real.rate = ZC_India
ZC_India[["Date"]] = NULL
rate = zoo(ZC_India)
index(rate) = as.POSIXct(paste(real.rate[["Date"]]))
maturity <- c(0.25, 0.5, 0.75, 1,2,3,4,5,6,7,8,9,10,12,15,20,25,30)
fixed_tau1 = (1.07612)
fixed_tau2 = (6.23293)

RF.5F.Parameters <- DRF.5F.tFix(rate, maturity, fixed_tau1, fixed_tau2)

par(mfrow=c(3,2))
 plot(RF.5F.Parameters[,"beta0"],xlab="Date",ylab="BETA0",ylim=c(7.0,9.0),col="blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta1"],xlab="Date",ylab="BETA1",ylim=c(-3.5,0.2),col="blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta2"],xlab="Date",ylab="BETA2",ylim=c(-1.5,1.0),col="blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta3"],xlab="Date",ylab="BETA3",ylim=c(-2.0,0.5),col="blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta4"],xlab="Date",ylab="BETA4",ylim=c(-2.5,5.0),col="blue",lwd=1)
 grid(nx=12, ny=12)
par(mfrow=c(1,1))

}
