% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_helper_functions.R,
%   R/design_print_summary.R
\name{post_design}
\alias{post_design}
\alias{print_code}
\alias{print.design}
\alias{summary.design}
\title{Explore your design}
\usage{
print_code(design)

\method{print}{design}(x, verbose = FALSE, ...)

\method{summary}{design}(object, verbose = TRUE, ...)
}
\arguments{
\item{design}{A design object, typically created using the + operator}

\item{x}{a design object, typically created using the + operator}

\item{verbose}{an indicator for printing a long summary of the design, defaults to \code{TRUE}}

\item{...}{optional arguments to be sent to summary function}

\item{object}{a design object created using the + operator}
}
\description{
Explore your design

Print code to recreate a design
}
\examples{

# Two-arm randomized experiment
design <-
  declare_model(
    N = 500,
    gender = rbinom(N, 1, 0.5),
    X = rep(c(0, 1), each = N / 2),
    U = rnorm(N, sd = 0.25),
    potential_outcomes(Y ~ 0.2 * Z + X + U)
  ) +
  declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_sampling(S = complete_rs(N = N, n = 200)) +
  declare_assignment(Z = complete_ra(N = N, m = 100)) +
  declare_measurement(Y = reveal_outcomes(Y ~ Z)) +
  declare_estimator(Y ~ Z, inquiry = "ATE")

# Use draw_data to create a dataset using a design
dat <- draw_data(design)

draw_data(design, data = dat, start = 2)

# Apply get_estimates
get_estimates(design, data = dat)


# Two-arm randomized experiment
design <-
  declare_model(
    N = 500,
    gender = rbinom(N, 1, 0.5),
    X = rep(c(0, 1), each = N / 2),
    U = rnorm(N, sd = 0.25),
    potential_outcomes(Y ~ 0.2 * Z + X + U)
  ) +
  declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_sampling(S = complete_rs(N = N, n = 200)) +
  declare_assignment(Z = complete_ra(N = N, m = 100)) +
  declare_measurement(Y = reveal_outcomes(Y ~ Z)) +
  declare_estimator(Y ~ Z, inquiry = "ATE")

print_code(design)

summary(design)


design <- 
  declare_model(
    N = 500, 
    noise = rnorm(N),
    Y_Z_0 = noise, 
    Y_Z_1 = noise + rnorm(N, mean = 2, sd = 2)
  ) + 
  declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) + 
  declare_sampling(S = complete_rs(N, n = 250)) + 
  declare_assignment(Z = complete_ra(N, m = 25)) +
  declare_measurement(Y = reveal_outcomes(Y ~ Z)) + 
  declare_estimator(Y ~ Z, inquiry = "ATE") 

summary(design)
}
