% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.cor.R
\name{approx.cor}
\alias{approx.cor}
\title{Correlation of time-series with different sampling rate}
\usage{
approx.cor(xy1, dt1, xy2, dt2, plot = T, output = T, type = "p", ...)
}
\arguments{
\item{xy1}{intensity values for the first data set}

\item{dt1}{depth or time scale for the first data set}

\item{xy2}{intensity values for the second data set}

\item{dt2}{depth or time scale for the second data set}

\item{plot}{whether to plot}

\item{output}{whether to output}

\item{type}{type of points in the plot (see help page of \code{lines()} for
details)}

\item{...}{additional parameters to feed to the \code{lines()} function}
}
\value{
a list of correlation ($cor), slope ($slope), intercept ($intercept)
(two values for each: interpolation to fit dt1 and dt2 respectively), and of
the xy1 and xy2 values, interpolated for dt1 ($df1) and df2 ($df2)
}
\description{
Allows to correlate time-series having different sampling rate,
if they have a comparable depth or time scale
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy.pure <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2)

xy <- xy.pure + rnorm(n, sd = 0.5)

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt.pure <- cumsum(inter_dt)

keep <- runif(length(dt.pure)) < 0.5

xy <- xy[keep]
dt <- dt.pure[keep] + rnorm(sum(keep), -0.2, 0.2)

par(mfrow = c(1,2))

plot(xy, dt, type = "o", pch = 19)

plot(xy.pure, dt.pure, type = "o", pch = 19)

par(mfrow = c(1,1))

out <- approx.cor(xy, dt, xy.pure, dt.pure)

out$cor
out$slope
out$intercept

}
