% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorCI.R
\name{CorCI}
\alias{CorCI}
\title{Confidence Intervals for Pearson Correlation}
\usage{
CorCI(
  rho,
  n,
  conf.level = 0.95,
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{rho}{the Pearson's correlation coefficient}

\item{n}{sample size used for calculating the confidence intervals}

\item{conf.level}{confidence level for the returned confidence interval,
restricted to lie between zero and one.}

\item{alternative}{is a character string, one of \code{"greater"},
\code{"less"}, or \code{"two.sided"}, or the initial letter of each,
indicating the specification of the alternative hypothesis.
\code{"greater"} corresponds to positive association, \code{"less"} to
negative association.}
}
\value{
rho, lower and upper confidence intervals (CorCI) \cr
}
\description{
Find the confidence intervals for a specified correlation based on
Fisher's z-transformation.
}
\details{
The sampling distribution of Pearson's r is not normal. Fisher
developed a transformation now called "Fisher's z-transformation"
used for the calculation of normal distributed confidence intervals.
}
\examples{

cors <- seq(-.9, .9, .1)

zs <- FisherZ(cors)
rs <- FisherZInv(zs)
round(zs, 2)
n <- 30
r <- seq(0, .9, .1)
rc <- t(sapply(r, CorCI, n=n))
t <- r * sqrt(n-2) / sqrt(1-r^2)
p <- (1 - pt(t, n-2)) / 2

r.rc <- data.frame(r=r, z=FisherZ(r), lower=rc[,2], upper=rc[,3], t=t, p=p)

round(r.rc,2)

}
\seealso{
\code{\link{FisherZ}}, \code{\link{FisherZInv}}
}
\author{
William Revelle \href{mailto:revelle@northwestern.edu}{revelle@northwestern.edu}, \cr slight
modifications Andri Signorell \href{mailto:andri@signorell.net}{andri@signorell.net} based on R-Core code
}
\keyword{models}
\keyword{multivariate}
