calculate_sentiment_stats <- function(data) {
  
  # Overall sentiment distribution
  sentiment_dist <- table(data$sentiment_category)
  sentiment_pct <- prop.table(sentiment_dist) * 100
  
  # Most extreme comments
  most_negative_idx <- which.min(data$sentiment_score)
  most_positive_idx <- which.max(data$sentiment_score)
  
  most_negative <- data[most_negative_idx, ]
  most_positive <- data[most_positive_idx, ]
  
  # Summary statistics
  stats <- list(
    overall_sentiment = list(
      mean_score = mean(data$sentiment_score, na.rm = TRUE),
      median_score = median(data$sentiment_score, na.rm = TRUE),
      distribution = sentiment_dist,
      percentages = sentiment_pct
    ),
    extreme_comments = list(
      most_negative = most_negative,
      most_positive = most_positive
    ),
    summary = list(
      total_comments = nrow(data),
      positive_count = sum(data$sentiment_category == "Positive"),
      negative_count = sum(data$sentiment_category == "Negative"),
      neutral_count = sum(data$sentiment_category == "Neutral")
    )
  )
  
  return(stats)
}