plot_sentiment_distribution <- function(data, plot_type = "bar") {
  
  if (!requireNamespace("ggplot2", quietly = TRUE)) {
    stop("Package ggplot2 is required but not installed.")
  }
  
  if (plot_type == "pie") {
    # Pie chart of sentiment distribution
    sentiment_counts <- table(data$sentiment_category)
    pie(sentiment_counts, 
        col = c("red", "blue", "green")[1:length(sentiment_counts)],
        main = "Sentiment Distribution")
    
  } else if (plot_type == "bar") {
    # Bar chart of sentiment
    p <- ggplot2::ggplot(data, ggplot2::aes(x = sentiment_category, fill = sentiment_category)) +
      ggplot2::geom_bar() +
      ggplot2::scale_fill_manual(values = c("Negative" = "red", "Neutral" = "blue", "Positive" = "green")) +
      ggplot2::theme_minimal() +
      ggplot2::labs(title = "Sentiment Distribution", x = "Sentiment Category", y = "Count")
    
    return(p)
    
  } else if (plot_type == "histogram") {
    # Histogram of sentiment scores
    p <- ggplot2::ggplot(data, ggplot2::aes(x = sentiment_score)) +
      ggplot2::geom_histogram(bins = 20, fill = "skyblue", alpha = 0.7, color = "black") +
      ggplot2::geom_vline(ggplot2::aes(xintercept = mean(sentiment_score)), color = "red", linetype = "dashed") +
      ggplot2::theme_minimal() +
      ggplot2::labs(title = "Distribution of Sentiment Scores", x = "Sentiment Score", y = "Frequency")
    
    return(p)
    
  } else if (plot_type == "geographic") {
    # Geographic plot
    p <- ggplot2::ggplot(data, ggplot2::aes(x = Longitude, y = Latitude, color = sentiment_category)) +
      ggplot2::geom_point(alpha = 0.7, size = 3) +
      ggplot2::scale_color_manual(values = c("Negative" = "red", "Neutral" = "blue", "Positive" = "green")) +
      ggplot2::theme_minimal() +
      ggplot2::labs(title = "Geographic Distribution of Sentiment")
    
    return(p)
  }
}
