% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dDPERKS.R
\name{dDPERKS}
\alias{dDPERKS}
\alias{pDPERKS}
\alias{rDPERKS}
\alias{qDPERKS}
\title{The Discrete Perks distribution}
\usage{
dDPERKS(x, mu = 0.5, sigma = 0.5, log = FALSE)

pDPERKS(q, mu = 0.5, sigma = 0.5, lower.tail = TRUE, log.p = FALSE)

rDPERKS(n, mu = 0.5, sigma = 0.5)

qDPERKS(p, mu = 0.5, sigma = 0.5, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x, q}{vector of (non-negative integer) quantiles.}

\item{mu}{vector of the mu parameter.}

\item{sigma}{vector of the sigma parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X <= x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}

\item{p}{vector of probabilities.}
}
\value{
\code{dDPERKS} gives the density, \code{pDPERKS} gives the distribution
function, \code{qDPERKS} gives the quantile function, \code{rDPERKS}
generates random deviates.
}
\description{
These functions define the density, distribution function, quantile
function and random generation for the Discrete Perks, DPERKS(),
distribution
with parameters \eqn{\mu} and \eqn{\sigma}.
}
\details{
The discrete Perks distribution with parameters \eqn{\mu > 0} and \eqn{\sigma > 0}
has a support 0, 1, 2, ... and density given by

\eqn{f(x | \mu, \sigma) = \frac{\mu(1+\mu)(e^\sigma-1)e^{\sigma x}}{(1+\mu e^{\sigma x})(1+\mu e^{\sigma(x+1)})} }

Note: in this implementation we changed the original parameters
\eqn{\lambda} for \eqn{\mu} and \eqn{\beta} for \eqn{\sigma},
we did it to implement this distribution within gamlss framework.
}
\examples{
# Example 1
# Plotting the mass function for diferent parameter values

x_max <- 25
probs1 <- dDPERKS(x=0:x_max, mu=0.001, sigma=0.52)
probs2 <- dDPERKS(x=0:x_max, mu=0.001, sigma=0.85)
probs3 <- dDPERKS(x=0:x_max, mu=0.001, sigma=1.5)

# To plot the first k values
plot(x=0:x_max, y=probs1, type="o", lwd=2, col="dodgerblue", las=1,
     ylab="P(X=x)", xlab="X", main="Probability for Perks",
     ylim=c(0, 0.40))
points(x=0:x_max, y=probs2, type="o", lwd=2, col="tomato")
points(x=0:x_max, y=probs3, type="o", lwd=2, col="green4")
legend("topright", col=c("dodgerblue", "tomato", "green4"), lwd=3,
       legend=c("mu=0.001, sigma=0.52 ",
                "mu=0.001, sigma=0.85",
                "mu=0.001, sigma=1.5"))

# Example 2
# Checking if the cumulative curves converge to 1

x_max <- 25
cumulative_probs1 <- pDPERKS(q=0:x_max, mu=0.001, sigma=0.52)
cumulative_probs2 <- pDPERKS(q=0:x_max, mu=0.001, sigma=0.85)
cumulative_probs3 <- pDPERKS(q=0:x_max, mu=0.001, sigma=1.5)

plot(x=0:x_max, y=cumulative_probs1, col="dodgerblue",
     type="o", las=1, ylim=c(0, 1),
     main="Cumulative probability for Perks",
     xlab="X", ylab="Probability")
points(x=0:x_max, y=cumulative_probs2, type="o", col="tomato")
points(x=0:x_max, y=cumulative_probs3, type="o", col="green4")
legend("bottomright", col=c("dodgerblue", "tomato", "green4"), lwd=3,
       legend=c("mu=0.001, sigma=0.52 ",
                "mu=0.001, sigma=0.85",
                "mu=0.001, sigma=1.5"))

# Example 3
# Comparing the random generator output with the theoretical probabilities

x_max <- 50
mu <- 2.5
sigma <- 0.4
probs1 <- dDPERKS(x=0:x_max, mu=mu, sigma=sigma)
names(probs1) <- 0:x_max

x <- rDPERKS(n=1000, mu=mu, sigma=sigma)
probs2 <- prop.table(table(x))

cn <- union(names(probs1), names(probs2))
height <- rbind(probs1[cn], probs2[cn])
nombres <- cn
mp <- barplot(height, beside = TRUE, names.arg = nombres,
              col=c('dodgerblue3','firebrick3'), las=1,
              xlab='X', ylab='Proportion')
legend('topright',
       legend=c('Theoretical', 'Simulated'),
       bty='n', lwd=3,
       col=c('dodgerblue3','firebrick3'), lty=1)

# Example 4
# Checking the quantile function

mu <- 0.2
sigma <- 0.2
p <- seq(from=0, to=1, by=0.01)
qxx <- qDPERKS(p=p, mu=mu, sigma=sigma, lower.tail=TRUE, log.p=FALSE)
plot(p, qxx, type="s", lwd=2, col="green3", ylab="quantiles",
     main="Quantiles of DPERKS(mu = sigma = 0.03)")


}
\references{
Tyagi, A., Choudhary, N., & Singh, B. (2020). A new discrete
distribution: Theory and applications to discrete failure
lifetime and count data. J. Appl. Probab. Statist, 15, 117-143.
}
\seealso{
\link{DPERKS}.
}
\author{
Veronica Seguro Varela, \email{vseguro@unal.edu.co}
}
