% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksgof.R
\name{ksgof}
\alias{ksgof}
\title{Perform the Lilliefors (Kolmogorov-Smirnov) Goodness-of-Fit Test for Normality}
\usage{
ksgof(x)
}
\arguments{
\item{x}{A numeric vector containing the sample data.}
}
\value{
\item{statistic}{The value of the Lilliefors (Kolmogorov-Smirnov) test statistic.}
\item{p.value}{The p-value for the test.}
\item{method}{A character string describing the test.}
}
\description{
Perform the Lilliefors (Kolmogorov-Smirnov) Goodness-of-Fit Test for Normality
}
\examples{
# Example usage:
set.seed(123)
x <- rnorm(100)  # Generate a sample from a normal distribution
result <- ksgof(x)
print(result)

# Example with non-normal data:
y <- rexp(100)  # Generate a sample from an exponential distribution
result <- ksgof(y)
print(result)
}
