% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NormalVaRPlot2DCL.R
\name{NormalVaRPlot2DCL}
\alias{NormalVaRPlot2DCL}
\title{Plots normal VaR against confidence level}
\usage{
NormalVaRPlot2DCL(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 3
 or 4. In case there are 3 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 cl VaR confidence level and must be a vector

 hp VaR holding period and must be a scalar}
}
\description{
Plots the VaR of a portfolio against confidence level assuming that P/L are normally distributed, for specified confidence level and
 holding period.
}
\examples{
# Plots VaR against confidene level given P/L data
   data <- runif(5, min = 0, max = .2)
   NormalVaRPlot2DCL(returns = data, cl = seq(.85,.99,.01), hp = 60)

   # Computes VaR against confidence level given mean and standard deviation of return data
   NormalVaRPlot2DCL(mu = .012, sigma = .03, cl = seq(.85,.99,.01), hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

