% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DyMEP_visualizer.R
\name{DyMEP_DRC_visualizer}
\alias{DyMEP_DRC_visualizer}
\title{DyMEP_DRC_visualizer}
\usage{
DyMEP_DRC_visualizer(detailed_output)
}
\arguments{
\item{detailed_output}{Output of the pheno_phase_prediction function with
output_type = "detailed_information".}
}
\value{
Returns plots showing the DRC curves for each phenological phase and
        environmental covariate. Each row represents a phenology phase.
}
\description{
Visualizes the Dose-Response Curves (DRC) for each phenological phase and
environmental covariate.
}
\examples{
phase_covariate_list <- best_DyMEP_model(env_covariates =
c("tas","tasmin","VPD","SPI","global_radiation","tasmax","RH"),
pheno_phases = c("sowing-emergence","emergence-jointing","jointing-heading"),
crop_abbrev = "WW",
output_list_for_prediction = TRUE)
# create dummy environmental data
environmental_data<- data.frame("DATE"=seq.Date(from = as.Date("2021-01-01"),
                   to = as.Date("2023-12-31"),by=1),
                                "tas"=runif(1095,min=-10,max=40),
                                "RH"=runif(1095,min=0,max=100),
                                "tasmin"=runif(1095,min=-10,max=40),
                                "tasmax"=runif(1095,min=0,max=40),
                                "VPD" = runif(1095,min=0,max=40),
                                "SPI"= runif(1095,min=-1,max=4),
                             "global_radiation"= runif(1095,min=0,max=3500))

DyMEP_DRC_visualizer(detailed_output = pheno_phase_prediction(
phase_covariate_list = phase_covariate_list,
environmental_data = environmental_data,
phase_starting_date =as.Date("2021-01-01"),
crop_abbrev = "WW",
output_type = "detailed_information")
)
}
\keyword{visualization}
