% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DyMEP_dose_response_curves.R
\name{WangEngels_prediction}
\alias{WangEngels_prediction}
\title{DRC function: WangEngels_prediction}
\usage{
WangEngels_prediction(x, params)
}
\arguments{
\item{x}{effective env_variable value}

\item{params}{list of input parameter; xmin_value represents the minimal
env_variable value above which growth response will happen ;
xopt_value: optimal growth point, env_variable values here have the highest
 response;
xmax_value represents the maximal env_variable value above which no growth
response will happen according to the wang engel model.}
}
\value{
value with WangEngels response
}
\description{
DRC function: WangEngels_prediction
}
\examples{
WangEngels_prediction(10, params = list("xmin_value"=1,
                                       "xopt_value"=25,
                                       "xmax_value"=35,
                                        "r_value"=0.5))
 # visualization
WangEngels <- lapply(seq(0, 40, 0.1),
WangEngels_prediction,
list("xmin_value"=1,
     "xopt_value"=25,
      "xmax_value"=35,
       "r_value"=0.5))
       plot(seq(0, 40, 0.1), WangEngels)
}
\keyword{DRC}
