% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DysPIA.R
\name{DysPIA}
\alias{DysPIA}
\title{DysPIA: Dysregulated Pathway Identification Analysis}
\usage{
DysPIA(
  pathwayDB = "kegg",
  stats,
  nperm = 10000,
  minSize = 15,
  maxSize = 1000,
  nproc = 0,
  DyspiaParam = 1,
  BPPARAM = NULL
)
}
\arguments{
\item{pathwayDB}{Name of the pathway database (8 databases:reactome,kegg,biocarta,panther,pathbank,nci,smpdb,pharmgkb). 
The default value is "kegg".}

\item{stats}{Named vector of CILP scores for each gene pair. Names should be the same as in pathways.}

\item{nperm}{Number of permutations to do. Minimial possible nominal p-value is about 1/nperm. 
The default value is 10000.}

\item{minSize}{Minimal size of a gene pair set to test. All pathways below the threshold are excluded. 
The default value is 15.}

\item{maxSize}{Maximal size of a gene pair set to test. All pathways above the threshold are excluded. 
The default value is 1000.}

\item{nproc}{If not equal to zero sets BPPARAM to use nproc workers (default = 0).}

\item{DyspiaParam}{DysPIA parameter value, all gene pair-level status are raised to the power of `DyspiaParam`
before calculation of DysPIA enrichment scores.}

\item{BPPARAM}{Parallelization parameter used in bplapply.
Can be used to specify cluster to run. If not initialized explicitly or
by setting `nproc` default value `bpparam()` is used.}
}
\value{
A table with DysPIA results. Each row corresponds to a tested pathway.
The columns are the following:
\itemize{
 \item pathway -- name of the pathway as in `names(pathway)`;
 \item pval -- an enrichment p-value;
 \item padj -- a BH-adjusted p-value;
 \item DysPS -- enrichment score, same as in Broad DysPIA implementation;
 \item NDysPS -- enrichment score normalized to mean enrichment of random samples of the same size;
 \item nMoreExtreme` -- a number of times a random gene pair set had a more extreme enrichment score value;
 \item size -- size of the pathway after removing gene pairs not present in `names(stats)`;
 \item leadingEdge -- vector with indexes of leading edge gene pairs that drive the enrichment.
}
}
\description{
Runs Dysregulated Pathway Identification Analysis (DysPIA).The package 'DysPIAData' including the background data is needed to be loaded.
}
\examples{
data(pathway_list,package="DysPIAData")
data(DysGPS_p53)
DyspiaRes_p53 <- DysPIA("kegg", DysGPS_p53, nperm = 100, minSize = 20, maxSize = 100)

}
