% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_plot.R
\name{fit_plot}
\alias{fit_plot}
\title{Plot observed and modeled dissolved oxygen}
\usage{
fit_plot(res, bygroup = FALSE, scatter = FALSE, showfit = TRUE)
}
\arguments{
\item{res}{output data frame from \code{\link{ebase}}}

\item{bygroup}{logical indicating if the plot is faceted by group}

\item{scatter}{logical indicating if a scatter plot of modeled versus estimated dissolved oxygen is returned}

\item{showfit}{logical indicating if a linear fit is shown in the plot, applies only if \code{scatter = TRUE}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot observed and modeled dissolved oxygen
}
\details{
Dissolved oxygen (mmol/m3) is plotted as observed from the input data (points) and modeled (lines) based on inputs to \code{\link{ebase}} if \code{scatter = FALSE}.  A scatter plot of modeled versus estimated dissolved oxygen is returned if \code{scatter = TRUE}, including a linear fit if \code{showfit = TRUE}.  The plot is faceted by group based on the \code{ndays} argument to \code{\link{ebase}} if \code{bygroup = TRUE}.  The r-squared value of the fit between modeled and observed dissolved oxygen is also shown in the facet label for the group if \code{bygroup = TRUE}.
}
\examples{
# plot observed and modeled DO
fit_plot(exres)

# plot observed and modeled DO by group
fit_plot(exres, bygroup = TRUE)

# as scatter plot
fit_plot(exres, scatter = TRUE)

# as scatter plot by group
fit_plot(exres, scatter = TRUE, bygroup = TRUE)
}
